/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.imunity.scim.common.Meta;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.Assert;

@JsonPropertyOrder(value={"schemas", "id", "externalId"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class BasicSCIMResource {
    public final String id;
    public final String externalId;
    public final Meta meta;
    public final Set<String> schemas;

    protected BasicSCIMResource(BasicScimResourceBuilder<?> builder) {
        this.id = builder.id;
        this.externalId = builder.externalId;
        this.meta = builder.meta;
        this.schemas = Set.copyOf(builder.schemas);
    }

    public int hashCode() {
        return Objects.hash(this.externalId, this.id, this.meta, this.schemas);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicSCIMResource other = (BasicSCIMResource)obj;
        return Objects.equals(this.externalId, other.externalId) && Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.schemas, other.schemas);
    }

    public static class BasicScimResourceBuilder<T extends BasicScimResourceBuilder<?>> {
        private String id;
        private String externalId;
        private Meta meta;
        private Set<String> schemas = Collections.emptySet();

        protected BasicScimResourceBuilder() {
        }

        public T withId(String id) {
            this.id = id;
            return (T)this;
        }

        public T withExternalId(String externalId) {
            this.externalId = externalId;
            return (T)this;
        }

        public T withMeta(Meta meta) {
            this.meta = meta;
            return (T)this;
        }

        public T withSchemas(Set<String> schemas) {
            this.schemas = schemas;
            return (T)this;
        }

        public BasicSCIMResource build() {
            Assert.notNull((Object)this.id, (String)"id cannot be null.");
            Assert.notNull(this.schemas, (String)"schemas cannot be null.");
            Assert.notEmpty(this.schemas, (String)"schemas cannot be empty.");
            return new BasicSCIMResource(this);
        }
    }
}

