/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim;

import io.imunity.scim.SCIMRestControllerFactory;
import io.imunity.scim.config.SCIMEndpointConfiguration;
import io.imunity.scim.config.SCIMEndpointDescription;
import io.imunity.scim.config.SCIMEndpointPropertiesConfigurationMapper;
import io.imunity.scim.exception.providers.SCIMEndpointExceptionMapper;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.EntityManagement;
import pl.edu.icm.unity.engine.api.authn.AuthenticationProcessor;
import pl.edu.icm.unity.engine.api.endpoint.EndpointFactory;
import pl.edu.icm.unity.engine.api.endpoint.EndpointInstance;
import pl.edu.icm.unity.engine.api.server.AdvertisedAddressProvider;
import pl.edu.icm.unity.engine.api.server.NetworkServer;
import pl.edu.icm.unity.engine.api.session.SessionManagement;
import pl.edu.icm.unity.engine.api.utils.PrototypeComponent;
import pl.edu.icm.unity.rest.RESTEndpoint;
import pl.edu.icm.unity.types.endpoint.EndpointTypeDescription;

@PrototypeComponent
public class SCIMEndpoint
extends RESTEndpoint {
    public static final String NAME = "SCIM";
    public static final String PATH = "";
    public static final EndpointTypeDescription TYPE = new EndpointTypeDescription("SCIM", "A RESTful endpoint exposing SCIM API.", "jaxrs2", Collections.singletonMap("", "The SCIM base path"));
    private final List<SCIMRestControllerFactory> factories;
    protected SCIMEndpointConfiguration scimEndpointConfiguration;

    @Autowired
    public SCIMEndpoint(MessageSource msg, SessionManagement sessionMan, NetworkServer server, AuthenticationProcessor authnProcessor, List<SCIMRestControllerFactory> factories, AdvertisedAddressProvider advertisedAddrProvider, EntityManagement entityMan) {
        super(msg, sessionMan, authnProcessor, server, advertisedAddrProvider, PATH, entityMan);
        this.factories = factories;
    }

    protected void setSerializedConfiguration(String serializedState) {
        super.setSerializedConfiguration(serializedState);
        this.scimEndpointConfiguration = SCIMEndpointPropertiesConfigurationMapper.fromProperties(serializedState);
    }

    protected Application getApplication() {
        return new SCIMJAXRSApp();
    }

    @Component
    public static class Factory
    implements EndpointFactory {
        @Autowired
        private ObjectFactory<SCIMEndpoint> factory;

        public EndpointTypeDescription getDescription() {
            return TYPE;
        }

        public EndpointInstance newInstance() {
            return (EndpointInstance)this.factory.getObject();
        }
    }

    @ApplicationPath(value="/")
    public class SCIMJAXRSApp
    extends Application {
        public Set<Object> getSingletons() {
            SCIMEndpointDescription enDesc = new SCIMEndpointDescription(URI.create(SCIMEndpoint.this.getServletUrl(SCIMEndpoint.PATH)), SCIMEndpoint.this.scimEndpointConfiguration.rootGroup, SCIMEndpoint.this.scimEndpointConfiguration.membershipGroups, SCIMEndpoint.this.scimEndpointConfiguration.schemas, SCIMEndpoint.this.scimEndpointConfiguration.membershipAttributes);
            Set<Object> ret = SCIMEndpoint.this.factories.stream().map(f -> f.getController(enDesc)).collect(Collectors.toSet());
            SCIMEndpointExceptionMapper.installExceptionHandlers(ret);
            return ret;
        }
    }
}

