/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.timer;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.AbstractGs2Client;
import io.gs2.model.IGs2Credential;
import io.gs2.timer.control.CreateTimerPoolRequest;
import io.gs2.timer.control.CreateTimerPoolResult;
import io.gs2.timer.control.CreateTimerRequest;
import io.gs2.timer.control.CreateTimerResult;
import io.gs2.timer.control.DeleteTimerPoolRequest;
import io.gs2.timer.control.DeleteTimerRequest;
import io.gs2.timer.control.DescribeTimerPoolRequest;
import io.gs2.timer.control.DescribeTimerPoolResult;
import io.gs2.timer.control.DescribeTimerRequest;
import io.gs2.timer.control.DescribeTimerResult;
import io.gs2.timer.control.GetTimerPoolRequest;
import io.gs2.timer.control.GetTimerPoolResult;
import io.gs2.timer.control.GetTimerRequest;
import io.gs2.timer.control.GetTimerResult;
import io.gs2.timer.control.UpdateTimerPoolRequest;
import io.gs2.timer.control.UpdateTimerPoolResult;
import java.util.ArrayList;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class Gs2TimerClient
extends AbstractGs2Client<Gs2TimerClient> {
    public static String ENDPOINT = "timer";

    public Gs2TimerClient(IGs2Credential credential) {
        super(credential);
    }

    public CreateTimerResult createTimer(CreateTimerRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("callbackMethod", request.getCallbackMethod()).put("executeTime", request.getExecuteTime()).put("callbackUrl", request.getCallbackUrl());
        if (request.getRetryMax() != null) {
            body.put("retryMax", request.getRetryMax());
        }
        if (request.getCallbackBody() != null) {
            body.put("callbackBody", request.getCallbackBody());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/timerPool/" + (request.getTimerPoolName() == null ? "null" : request.getTimerPoolName()) + "/timer", this.credential, ENDPOINT, "Gs2Timer", "CreateTimer", body.toString());
        return (CreateTimerResult)this.doRequest((HttpUriRequest)post, CreateTimerResult.class);
    }

    public CreateTimerPoolResult createTimerPool(CreateTimerPoolRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("name", request.getName()).put("description", request.getDescription());
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/timerPool", this.credential, ENDPOINT, "Gs2Timer", "CreateTimerPool", body.toString());
        return (CreateTimerPoolResult)this.doRequest((HttpUriRequest)post, CreateTimerPoolResult.class);
    }

    public void deleteTimer(DeleteTimerRequest request) {
        String url = "https://{service}.{region}.gs2.io/timerPool/" + (request.getTimerPoolName() == null ? "null" : request.getTimerPoolName()) + "/timer/" + (request.getTimerId() == null ? "null" : request.getTimerId()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Timer", "DeleteTimer");
        this.doRequest((HttpUriRequest)delete, null);
    }

    public void deleteTimerPool(DeleteTimerPoolRequest request) {
        String url = "https://{service}.{region}.gs2.io/timerPool/" + (request.getTimerPoolName() == null ? "null" : request.getTimerPoolName()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Timer", "DeleteTimerPool");
        this.doRequest((HttpUriRequest)delete, null);
    }

    public DescribeTimerResult describeTimer(DescribeTimerRequest request) {
        String url = "https://{service}.{region}.gs2.io/timerPool/" + (request.getTimerPoolName() == null ? "null" : request.getTimerPoolName()) + "/timer";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Timer", "DescribeTimer");
        return (DescribeTimerResult)this.doRequest((HttpUriRequest)get, DescribeTimerResult.class);
    }

    public DescribeTimerPoolResult describeTimerPool(DescribeTimerPoolRequest request) {
        String url = "https://{service}.{region}.gs2.io/timerPool";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Timer", "DescribeTimerPool");
        return (DescribeTimerPoolResult)this.doRequest((HttpUriRequest)get, DescribeTimerPoolResult.class);
    }

    public GetTimerResult getTimer(GetTimerRequest request) {
        String url = "https://{service}.{region}.gs2.io/timerPool/" + (request.getTimerPoolName() == null ? "null" : request.getTimerPoolName()) + "/timer/" + (request.getTimerId() == null ? "null" : request.getTimerId()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Timer", "GetTimer");
        return (GetTimerResult)this.doRequest((HttpUriRequest)get, GetTimerResult.class);
    }

    public GetTimerPoolResult getTimerPool(GetTimerPoolRequest request) {
        String url = "https://{service}.{region}.gs2.io/timerPool/" + (request.getTimerPoolName() == null ? "null" : request.getTimerPoolName()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Timer", "GetTimerPool");
        return (GetTimerPoolResult)this.doRequest((HttpUriRequest)get, GetTimerPoolResult.class);
    }

    public UpdateTimerPoolResult updateTimerPool(UpdateTimerPoolRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("description", request.getDescription());
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2.io/timerPool/" + (request.getTimerPoolName() == null ? "null" : request.getTimerPoolName()) + "", this.credential, ENDPOINT, "Gs2Timer", "UpdateTimerPool", body.toString());
        return (UpdateTimerPoolResult)this.doRequest((HttpUriRequest)put, UpdateTimerPoolResult.class);
    }
}

