/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.script;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.AbstractGs2Client;
import io.gs2.model.IGs2Credential;
import io.gs2.script.control.CreateScriptRequest;
import io.gs2.script.control.CreateScriptResult;
import io.gs2.script.control.DeleteScriptRequest;
import io.gs2.script.control.DescribeScriptRequest;
import io.gs2.script.control.DescribeScriptResult;
import io.gs2.script.control.GetScriptRequest;
import io.gs2.script.control.GetScriptResult;
import io.gs2.script.control.UpdateScriptRequest;
import io.gs2.script.control.UpdateScriptResult;
import java.util.ArrayList;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class Gs2ScriptClient
extends AbstractGs2Client<Gs2ScriptClient> {
    public static String ENDPOINT = "script";

    public Gs2ScriptClient(IGs2Credential credential) {
        super(credential);
    }

    public CreateScriptResult createScript(CreateScriptRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("name", request.getName()).put("description", request.getDescription()).put("script", request.getScript());
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/script", this.credential, ENDPOINT, "Gs2Script", "CreateScript", body.toString());
        return (CreateScriptResult)this.doRequest((HttpUriRequest)post, CreateScriptResult.class);
    }

    public DescribeScriptResult describeScript(DescribeScriptRequest request) {
        String url = "https://{service}.{region}.gs2.io/script";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", request.getPageToken()));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Script", "DescribeScript");
        return (DescribeScriptResult)this.doRequest((HttpUriRequest)get, DescribeScriptResult.class);
    }

    public GetScriptResult getScript(GetScriptRequest request) {
        HttpGet get = this.createHttpGet("https://{service}.{region}.gs2.io/script/" + request.getScriptName(), this.credential, ENDPOINT, "Gs2Script", "GetScript");
        return (GetScriptResult)this.doRequest((HttpUriRequest)get, GetScriptResult.class);
    }

    public UpdateScriptResult updateScript(UpdateScriptRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("description", request.getDescription()).put("script", request.getScript());
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2.io/script/" + request.getScriptName(), this.credential, ENDPOINT, "Gs2Script", "UpdateScript", body.toString());
        return (UpdateScriptResult)this.doRequest((HttpUriRequest)put, UpdateScriptResult.class);
    }

    public void deleteScript(DeleteScriptRequest request) {
        HttpDelete delete = this.createHttpDelete("https://{service}.{region}.gs2.io/script/" + request.getScriptName(), this.credential, ENDPOINT, "Gs2Script", "DeleteScript");
        this.doRequest((HttpUriRequest)delete, null);
    }
}

