/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.openapi.util;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.exception.ApolloException;
import io.growing.sdk.openapi.util.ConfigUtils;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

public class GraphqlClient {
    private static final ApolloClient CLIENT = ApolloClient.builder().serverUrl(ConfigUtils.getStringValue("api", "http://gdp.growingio.com")).okHttpClient(new OkHttpClient.Builder().addInterceptor(chain -> chain.proceed(chain.request().newBuilder().addHeader("Authorization", ConfigUtils.getStringValue("token", "")).build())).build()).build();

    private static <T> CompletableFuture<Response<T>> toCompletableFuture(ApolloCall<T> apolloCall) {
        final CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.whenComplete((tResponse, throwable) -> {
            if (completableFuture.isCancelled()) {
                completableFuture.cancel(true);
            }
        });
        apolloCall.enqueue(new ApolloCall.Callback<T>(){

            public void onResponse(@NotNull Response<T> response) {
                completableFuture.complete(response);
            }

            public void onFailure(@NotNull ApolloException e) {
                completableFuture.completeExceptionally((Throwable)e);
            }
        });
        return completableFuture;
    }

    public static <D extends Operation.Data, T, V extends Operation.Variables> CompletableFuture<Response<T>> query(Query<D, T, V> query) {
        return GraphqlClient.toCompletableFuture(CLIENT.query(query));
    }

    public static <D extends Operation.Data, T, V extends Operation.Variables> CompletableFuture<Response<T>> mutation(Mutation<D, T, V> mutation) {
        return GraphqlClient.toCompletableFuture(CLIENT.mutate(mutation));
    }
}

