/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.openapi.util;

import io.growing.sdk.openapi.exception.GIOMessageException;
import java.io.InputStream;
import java.util.Properties;

public class ConfigUtils {
    private static Properties prop = new Properties();

    public static String getStringValue(String key, String defaultValue) {
        return prop.getProperty(key, defaultValue);
    }

    public static Long getLongValue(String key, Long defaultValue) {
        String obj = prop.getProperty(key, defaultValue.toString());
        try {
            return Long.valueOf(obj);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Integer getIntValue(String key, Integer defaultValue) {
        String obj = prop.getProperty(key, defaultValue.toString());
        try {
            return Integer.valueOf(obj);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Boolean getBooleanValue(String key, Boolean defaultValue) {
        String obj = prop.getProperty(key, defaultValue.toString());
        try {
            return Boolean.valueOf(obj);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    static {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            InputStream gioProps = classLoader.getResourceAsStream("gio_api_default.properties");
            prop.load(gioProps);
            InputStream customProps = classLoader.getResourceAsStream("gio_api.properties");
            if (customProps != null) {
                prop.load(customProps);
            }
        }
        catch (Exception e) {
            throw new GIOMessageException("cant find gio.properties", e);
        }
    }
}

