/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.openapi.graphql;

import com.apollographql.apollo.api.InputFieldMarshaller;
import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ResponseFieldMarshaller;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ResponseWriter;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Mutator;
import com.apollographql.apollo.api.internal.SimpleOperationResponseParser;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.internal.QueryDocumentMinifier;
import com.apollographql.apollo.response.ScalarTypeAdapters;
import io.growing.sdk.openapi.graphql.type.CustomType;
import io.growing.sdk.openapi.graphql.type.JobStage;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JobResultQuery
implements Query<Data, Optional<Data>, Variables> {
    public static final String OPERATION_ID = "885ea7718b92826c11a7d4d7ea0da99e744bc163f028f393fc79758556cd848b";
    public static final String QUERY_DOCUMENT = QueryDocumentMinifier.minify((String)"query JobResult($id: HashId!) {\n  jobResult(id: $id) {\n    __typename\n    stage\n    uris\n  }\n}");
    public static final OperationName OPERATION_NAME = new OperationName(){

        public String name() {
            return "JobResult";
        }
    };
    private final Variables variables;

    public JobResultQuery(@NotNull String id) {
        Utils.checkNotNull((Object)id, (Object)"id == null");
        this.variables = new Variables(id);
    }

    public String operationId() {
        return OPERATION_ID;
    }

    public String queryDocument() {
        return QUERY_DOCUMENT;
    }

    public Optional<Data> wrapData(Data data) {
        return Optional.ofNullable(data);
    }

    public Variables variables() {
        return this.variables;
    }

    public ResponseFieldMapper<Data> responseFieldMapper() {
        return new Data.Mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    public OperationName name() {
        return OPERATION_NAME;
    }

    @NotNull
    public Response<Optional<Data>> parse(@NotNull BufferedSource source, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return SimpleOperationResponseParser.parse((BufferedSource)source, (Operation)this, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public Response<Optional<Data>> parse(@NotNull BufferedSource source) throws IOException {
        return this.parse(source, ScalarTypeAdapters.DEFAULT);
    }

    public static class JobResult {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"stage", (String)"stage", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"uris", (String)"uris", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final JobStage stage;
        final Optional<List<String>> uris;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public JobResult(@NotNull String __typename, @NotNull JobStage stage, @Nullable List<String> uris) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.stage = (JobStage)((Object)Utils.checkNotNull((Object)((Object)stage), (Object)"stage == null"));
            this.uris = Optional.ofNullable(uris);
        }

        @NotNull
        public String get__typename() {
            return this.__typename;
        }

        @NotNull
        public JobStage getStage() {
            return this.stage;
        }

        public Optional<List<String>> getUris() {
            return this.uris;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], stage.rawValue());
                    writer.writeList($responseFields[2], uris.isPresent() ? uris.get() : null, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeString((String)item);
                            }
                        }
                    });
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "JobResult{__typename=" + this.__typename + ", stage=" + (Object)((Object)this.stage) + ", uris=" + this.uris + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof JobResult) {
                JobResult that = (JobResult)o;
                return this.__typename.equals(that.__typename) && this.stage.equals((Object)that.stage) && this.uris.equals(that.uris);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.stage.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.uris.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.__typename = this.__typename;
            builder.stage = this.stage;
            builder.uris = this.uris.isPresent() ? this.uris.get() : null;
            return builder;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @NotNull
            private String __typename;
            @NotNull
            private JobStage stage;
            @Nullable
            private List<String> uris;

            Builder() {
            }

            public Builder __typename(@NotNull String __typename) {
                this.__typename = __typename;
                return this;
            }

            public Builder stage(@NotNull JobStage stage) {
                this.stage = stage;
                return this;
            }

            public Builder uris(@Nullable List<String> uris) {
                this.uris = uris;
                return this;
            }

            public JobResult build() {
                Utils.checkNotNull((Object)this.__typename, (Object)"__typename == null");
                Utils.checkNotNull((Object)((Object)this.stage), (Object)"stage == null");
                return new JobResult(this.__typename, this.stage, this.uris);
            }
        }

        public static final class Mapper
        implements ResponseFieldMapper<JobResult> {
            public JobResult map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String stageStr = reader.readString($responseFields[1]);
                JobStage stage = stageStr != null ? JobStage.safeValueOf(stageStr) : null;
                List uris = reader.readList($responseFields[2], (ResponseReader.ListReader)new ResponseReader.ListReader<String>(){

                    public String read(ResponseReader.ListItemReader listItemReader) {
                        return listItemReader.readString();
                    }
                });
                return new JobResult(__typename, stage, uris);
            }
        }
    }

    public static class Data
    implements Operation.Data {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forObject((String)"jobResult", (String)"jobResult", (Map)new UnmodifiableMapBuilder(1).put((Object)"id", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"id").build()).build(), (boolean)true, Collections.emptyList())};
        final Optional<JobResult> jobResult;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Data(@Nullable JobResult jobResult) {
            this.jobResult = Optional.ofNullable(jobResult);
        }

        public Optional<JobResult> getJobResult() {
            return this.jobResult;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeObject($responseFields[0], jobResult.isPresent() ? jobResult.get().marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Data{jobResult=" + this.jobResult + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data that = (Data)o;
                return this.jobResult.equals(that.jobResult);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.jobResult.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.jobResult = this.jobResult.isPresent() ? this.jobResult.get() : null;
            return builder;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private JobResult jobResult;

            Builder() {
            }

            public Builder jobResult(@Nullable JobResult jobResult) {
                this.jobResult = jobResult;
                return this;
            }

            public Builder jobResult(@NotNull Mutator<JobResult.Builder> mutator) {
                Utils.checkNotNull(mutator, (Object)"mutator == null");
                JobResult.Builder builder = this.jobResult != null ? this.jobResult.toBuilder() : JobResult.builder();
                mutator.accept((Object)builder);
                this.jobResult = builder.build();
                return this;
            }

            public Data build() {
                return new Data(this.jobResult);
            }
        }

        public static final class Mapper
        implements ResponseFieldMapper<Data> {
            final JobResult.Mapper jobResultFieldMapper = new JobResult.Mapper();

            public Data map(ResponseReader reader) {
                JobResult jobResult = (JobResult)reader.readObject($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<JobResult>(){

                    public JobResult read(ResponseReader reader) {
                        return jobResultFieldMapper.map(reader);
                    }
                });
                return new Data(jobResult);
            }
        }
    }

    public static final class Variables
    extends Operation.Variables {
        @NotNull
        private final String id;
        private final transient Map<String, Object> valueMap = new LinkedHashMap<String, Object>();

        Variables(@NotNull String id) {
            this.id = id;
            this.valueMap.put("id", id);
        }

        @NotNull
        public String id() {
            return this.id;
        }

        public Map<String, Object> valueMap() {
            return Collections.unmodifiableMap(this.valueMap);
        }

        public InputFieldMarshaller marshaller() {
            return new InputFieldMarshaller(){

                public void marshal(InputFieldWriter writer) throws IOException {
                    writer.writeCustom("id", (ScalarType)CustomType.HASHID, (Object)id);
                }
            };
        }
    }

    public static final class Builder {
        @NotNull
        private String id;

        Builder() {
        }

        public Builder id(@NotNull String id) {
            this.id = id;
            return this;
        }

        public JobResultQuery build() {
            Utils.checkNotNull((Object)this.id, (Object)"id == null");
            return new JobResultQuery(this.id);
        }
    }
}

