/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.process.impl;

import com.google.protobuf.Message;
import io.growing.collector.tunnel.protocol.ItemDtoList;
import io.growing.sdk.java.dto.GIOMessage;
import io.growing.sdk.java.dto.GioCdpItemMessage;
import io.growing.sdk.java.process.MessageProcessor;
import io.growing.sdk.java.process.impl.ProtobufMessage;
import io.growing.sdk.java.sender.net.ContentTypeEnum;
import java.util.List;
import java.util.Map;

public class GioCdpItemMessageProcessor
extends ProtobufMessage
implements MessageProcessor {
    @Override
    public String apiHost(String ai) {
        return this.apiDomain() + "/projects/" + ai + "/collect/item";
    }

    @Override
    public ContentTypeEnum contentType() {
        return ContentTypeEnum.PROTOBUF;
    }

    @Override
    public Map<String, String> headers() {
        return HEADERS;
    }

    @Override
    protected byte[] doProcess(List<GIOMessage> msgList) {
        ItemDtoList list = this.getItems(msgList);
        return null == list ? null : list.toByteArray();
    }

    private ItemDtoList getItems(List<GIOMessage> msgList) {
        ItemDtoList.Builder listBuilder = ItemDtoList.newBuilder();
        for (GIOMessage msg : msgList) {
            if (!(msg instanceof GioCdpItemMessage)) continue;
            GioCdpItemMessage cdp = (GioCdpItemMessage)msg;
            listBuilder.addValues(cdp.getMessage());
        }
        if (listBuilder.getValuesCount() > 0) {
            return listBuilder.build();
        }
        return null;
    }

    @Override
    protected String debugMessage(List<GIOMessage> msgList) {
        ItemDtoList list = this.getItems(msgList);
        return this.toJson((Message)this.getItems(msgList));
    }
}

