/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.process.impl;

import io.growing.sdk.java.constants.RunMode;
import io.growing.sdk.java.dto.GIOMessage;
import io.growing.sdk.java.logger.GioLogger;
import io.growing.sdk.java.process.MessageProcessor;
import io.growing.sdk.java.utils.ConfigUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractMessageProcessor
implements MessageProcessor {
    protected static final Map<String, String> HEADERS = new HashMap<String, String>();

    protected String apiDomain() {
        String apiHost = ConfigUtils.getStringValue("api.host", "");
        if (apiHost.endsWith("/")) {
            return apiHost.substring(0, apiHost.length() - 1);
        }
        return apiHost;
    }

    @Override
    public byte[] process(List<GIOMessage> msgList) {
        String debugMessage;
        if (RunMode.isTestMode().booleanValue() && (debugMessage = this.debugMessage(msgList)) != null) {
            GioLogger.debug("gio message is " + this.debugMessage(msgList));
        }
        return this.doProcess(msgList);
    }

    @Override
    public boolean skipIllegalMessage(GIOMessage gioMessage) {
        return gioMessage.isIllegal();
    }

    protected abstract byte[] doProcess(List<GIOMessage> var1);

    protected abstract String debugMessage(List<GIOMessage> var1);
}

