/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.dto;

import io.growing.collector.tunnel.protocol.UserMappingDto;
import io.growing.sdk.java.dto.GioCDPMessage;
import io.growing.sdk.java.logger.GioLogger;
import java.io.Serializable;
import java.util.Map;

public class GioCdpUserMappingMessage
extends GioCDPMessage<UserMappingDto>
implements Serializable {
    private static final long serialVersionUID = 8319050884751121301L;
    private final UserMappingDto event;

    private GioCdpUserMappingMessage(UserMappingDto.Builder builder) {
        this.event = builder.build();
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    @Override
    public UserMappingDto getMessage() {
        return this.event.toBuilder().setProjectKey(this.projectKey).setDataSourceId(this.dataSourceId).build();
    }

    @Override
    public boolean isIllegal() {
        if (this.event.getIdentifiesMap().isEmpty()) {
            GioLogger.error("GioCdpUserMappingMessage: identifies is empty");
            return true;
        }
        return false;
    }

    public static final class Builder {
        private final UserMappingDto.Builder builder = UserMappingDto.newBuilder();

        public GioCdpUserMappingMessage build() {
            return new GioCdpUserMappingMessage(this.builder);
        }

        public Builder eventTime(long eventTime) {
            this.builder.setSendTime(eventTime);
            return this;
        }

        public Builder addIdentities(String userKey, String userId) {
            if (userKey != null && userId != null) {
                this.builder.putIdentifies(userKey, userId);
            }
            return this;
        }

        public Builder addIdentities(Map<String, String> identifies) {
            if (identifies != null && !identifies.isEmpty()) {
                this.builder.putAllIdentifies(identifies);
            }
            return this;
        }
    }
}

