/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.dto;

import io.growing.collector.tunnel.protocol.ItemDto;
import io.growing.sdk.java.dto.GioCDPMessage;
import io.growing.sdk.java.logger.GioLogger;
import java.io.Serializable;

public class GioCdpItemMessage
extends GioCDPMessage<ItemDto>
implements Serializable {
    private static final long serialVersionUID = -2411957894363769098L;
    private final ItemDto event;

    private GioCdpItemMessage(ItemDto.Builder builder) {
        this.event = builder.build();
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    @Override
    public ItemDto getMessage() {
        return this.event.toBuilder().setProjectKey(this.projectKey).setDataSourceId(this.dataSourceId).build();
    }

    @Override
    public boolean isIllegal() {
        if (this.event.getId().isEmpty() || this.event.getKey().isEmpty()) {
            GioLogger.error("GioCdpItemMessage: id or key is empty");
            return true;
        }
        return false;
    }

    public static final class Builder {
        private final ItemDto.Builder builder = ItemDto.newBuilder();

        public GioCdpItemMessage build() {
            return new GioCdpItemMessage(this.builder);
        }

        public Builder id(String id) {
            if (id != null) {
                this.builder.setId(id);
            }
            return this;
        }

        public Builder key(String key) {
            if (key != null) {
                this.builder.setKey(key);
            }
            return this;
        }

        public Builder addItemVariable(String key, String value) {
            if (key != null && value != null) {
                this.builder.putAttributes(key, value);
            }
            return this;
        }
    }
}

