/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.dto;

import io.growing.collector.tunnel.protocol.EventType;
import io.growing.collector.tunnel.protocol.EventV3Dto;
import io.growing.collector.tunnel.protocol.ResourceItem;
import io.growing.sdk.java.dto.GioCDPMessage;
import io.growing.sdk.java.logger.GioLogger;
import java.io.Serializable;
import java.util.Map;

public class GioCdpEventMessage
extends GioCDPMessage<EventV3Dto>
implements Serializable {
    private static final long serialVersionUID = -2414503426226355459L;
    private final EventV3Dto event;

    private GioCdpEventMessage(EventV3Dto.Builder builder) {
        this.event = builder.setTimestamp(this.getTimeStampOrDefault(builder.getTimestamp())).setEventType(EventType.CUSTOM).build();
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    @Override
    public EventV3Dto getMessage() {
        return this.event.toBuilder().setProjectKey(this.projectKey).setDataSourceId(this.dataSourceId).build();
    }

    @Override
    public boolean isIllegal() {
        if (this.event.getEventName().isEmpty()) {
            GioLogger.error("GioCdpEventMessage: eventName is empty");
            return true;
        }
        return false;
    }

    public static final class Builder {
        private final EventV3Dto.Builder builder = EventV3Dto.newBuilder();

        public GioCdpEventMessage build() {
            return new GioCdpEventMessage(this.builder);
        }

        public Builder eventTime(long eventTime) {
            this.builder.setTimestamp(eventTime);
            this.builder.setSendTime(eventTime);
            return this;
        }

        public Builder eventKey(String eventKey) {
            if (eventKey != null) {
                this.builder.setEventName(eventKey);
            }
            return this;
        }

        public Builder loginUserId(String loginUserId) {
            if (loginUserId != null) {
                this.builder.setUserId(loginUserId);
                this.builder.setGioId(loginUserId);
            }
            return this;
        }

        public Builder loginUserKey(String loginUserKey) {
            if (loginUserKey != null) {
                this.builder.setUserKey(loginUserKey);
            }
            return this;
        }

        public Builder anonymousId(String anonymousId) {
            if (anonymousId != null) {
                this.builder.setDeviceId(anonymousId);
            }
            return this;
        }

        @Deprecated
        public Builder eventNumValue(Number numValue) {
            return this;
        }

        public Builder addEventVariable(String key, Integer value) {
            this.addVariableObject(key, value);
            return this;
        }

        public Builder addEventVariable(String key, Double value) {
            this.addVariableObject(key, value);
            return this;
        }

        public Builder addEventVariable(String key, String value) {
            this.addVariableObject(key, value);
            return this;
        }

        public Builder addEventVariables(Map<String, Object> variables) {
            if (variables != null && !variables.isEmpty()) {
                for (Map.Entry<String, Object> entry : variables.entrySet()) {
                    this.addVariableObject(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        public Builder addItem(String id, String key) {
            this.addItem(id, key, null);
            return this;
        }

        public Builder addItem(String id, String key, Map<String, String> variables) {
            if (id != null && key != null) {
                ResourceItem.Builder resourceItemBuilder = ResourceItem.newBuilder();
                resourceItemBuilder.setId(id);
                resourceItemBuilder.setKey(key);
                if (variables != null) {
                    resourceItemBuilder.putAllAttributes(variables);
                }
                this.builder.setResourceItem(resourceItemBuilder.build());
            }
            return this;
        }

        private Builder addVariableObject(String key, Object value) {
            if (key != null && value != null) {
                key = key.trim();
                this.builder.putAttributes(key, String.valueOf(value));
            }
            return this;
        }
    }
}

