/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.com.googlecode.protobuf.format.util;

import java.math.BigInteger;
import java.util.regex.Pattern;

public class TextUtils {
    private static final Pattern DIGITS = Pattern.compile("[0-9]", 2);

    public static String unsignedToString(long value) {
        if (value >= 0L) {
            return Long.toString(value);
        }
        return BigInteger.valueOf(value & Long.MAX_VALUE).setBit(63).toString();
    }

    public static String unsignedToString(int value) {
        if (value >= 0) {
            return Integer.toString(value);
        }
        return Long.toString((long)value & 0xFFFFFFFFL);
    }

    public static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    public static boolean isOctal(char c) {
        return '0' <= c && c <= '7';
    }

    public static int digitValue(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'z') {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    public static boolean isDigits(String text) {
        return DIGITS.matcher(text).matches();
    }
}

