/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.supplier;

import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.supplier.MappingConfigSupplier;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import java.io.File;
import java.io.IOException;

public class JsonMappingConfigSupplier
implements MappingConfigSupplier {
    private final String jsonConfigFile;

    public JsonMappingConfigSupplier(String jsonConfigFile) {
        this.jsonConfigFile = jsonConfigFile;
    }

    @Override
    public MappingConfig get() {
        if (this.jsonConfigFile != null && !this.jsonConfigFile.isEmpty()) {
            try {
                return (MappingConfig)Utils.OBJECT_MAPPER.readValue(new File(this.jsonConfigFile), MappingConfig.class);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }
}

