/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.model.definitions;

import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.AbstractDescribedNode;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.SourceLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public abstract class ExtendedDefinition<T extends NamedNode<T>, E extends T> {
    protected T definition;
    protected List<E> extensions = new ArrayList();

    public String getName() {
        if (this.definition != null) {
            return this.definition.getName();
        }
        return this.extensions.stream().map(NamedNode::getName).findFirst().orElse(null);
    }

    public SourceLocation getSourceLocation() {
        if (this.definition != null) {
            return this.definition.getSourceLocation();
        }
        return this.extensions.stream().map(Node::getSourceLocation).findFirst().orElse(null);
    }

    public List<String> getJavaDoc() {
        List<String> javaDocFromDescription = this.getJavaDocFromDescription();
        if (javaDocFromDescription.isEmpty()) {
            return this.getJavaDocFromComments();
        }
        return javaDocFromDescription;
    }

    public List<String> getJavaDocFromDescription() {
        ArrayList<String> descriptions = new ArrayList<String>();
        if (this.definition instanceof AbstractDescribedNode) {
            Description description = ((AbstractDescribedNode)this.definition).getDescription();
            if (description != null && Utils.isNotBlank(description.getContent())) {
                descriptions.add(description.getContent().trim());
            }
            this.extensions.stream().filter(Objects::nonNull).map(AbstractDescribedNode.class::cast).map(AbstractDescribedNode::getDescription).filter(Objects::nonNull).map(Description::getContent).filter(Utils::isNotBlank).map(String::trim).forEach(descriptions::add);
        }
        return descriptions;
    }

    public List<String> getJavaDocFromComments() {
        ArrayList<String> comments = new ArrayList<String>();
        if (this.definition != null && this.definition.getComments() != null) {
            this.definition.getComments().stream().map(Comment::getContent).filter(Utils::isNotBlank).map(String::trim).forEach(comments::add);
        }
        this.extensions.stream().map(Node::getComments).flatMap(Collection::stream).filter(Objects::nonNull).map(Comment::getContent).filter(Utils::isNotBlank).map(String::trim).forEach(comments::add);
        return comments;
    }

    public List<String> getDirectiveNames() {
        ArrayList<String> directives = new ArrayList<String>();
        if (this.definition instanceof DirectivesContainer) {
            List definitionDirectives = ((DirectivesContainer)this.definition).getDirectives();
            if (!Utils.isEmpty(definitionDirectives)) {
                definitionDirectives.stream().map(Directive::getName).forEach(directives::add);
            }
            this.extensions.stream().filter(Objects::nonNull).map(DirectivesContainer.class::cast).map(DirectivesContainer::getDirectives).filter(Objects::nonNull).forEach(ds -> ds.forEach(d -> directives.add(((Directive)d).getName())));
        }
        return directives;
    }

    public T getDefinition() {
        return this.definition;
    }

    public void setDefinition(T definition) {
        this.definition = definition;
    }

    public List<E> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<E> extensions) {
        this.extensions = extensions;
    }
}

