/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.FieldDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphqlTypeToJavaTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.InputValueDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.ProjectionParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedInterfaceTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedUnionTypeDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RequestResponseDefinitionToDataModelMapper {
    private RequestResponseDefinitionToDataModelMapper() {
    }

    public static Map<String, Object> mapResponseProjection(MappingContext mappingContext, ExtendedDefinition<?, ?> definition) {
        String className = Utils.capitalize(definition.getName()) + mappingContext.getResponseProjectionSuffix();
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", MapperUtils.getModelPackageName(mappingContext));
        dataModel.put("className", className);
        dataModel.put("annotations", GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, className));
        dataModel.put("javaDoc", Collections.singletonList("Response projection for " + definition.getName()));
        dataModel.put("fields", RequestResponseDefinitionToDataModelMapper.getProjectionFields(mappingContext, definition));
        dataModel.put("builder", mappingContext.getGenerateBuilder());
        dataModel.put("equalsAndHashCode", mappingContext.getGenerateEqualsAndHashCode());
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        dataModel.put("responseProjectionMaxDepth", mappingContext.getResponseProjectionMaxDepth());
        return dataModel;
    }

    public static Map<String, Object> mapParametrizedInput(MappingContext mappingContext, ExtendedFieldDefinition fieldDefinition, ExtendedDefinition<?, ?> parentTypeDefinition) {
        String className = MapperUtils.getParametrizedInputClassName(mappingContext, fieldDefinition, parentTypeDefinition);
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", MapperUtils.getModelPackageName(mappingContext));
        dataModel.put("className", className);
        dataModel.put("annotations", GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, className));
        dataModel.put("javaDoc", Collections.singletonList(String.format("Parametrized input for field %s in type %s", fieldDefinition.getName(), parentTypeDefinition.getName())));
        dataModel.put("fields", InputValueDefinitionToParameterMapper.map(mappingContext, fieldDefinition.getInputValueDefinitions(), parentTypeDefinition.getName()));
        dataModel.put("builder", mappingContext.getGenerateBuilder());
        dataModel.put("equalsAndHashCode", mappingContext.getGenerateEqualsAndHashCode());
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        return dataModel;
    }

    public static Map<String, Object> mapResponse(MappingContext mappingContext, ExtendedFieldDefinition operationDef, String objectTypeName, List<String> fieldNames) {
        String className = RequestResponseDefinitionToDataModelMapper.getClassName(operationDef, fieldNames, objectTypeName, mappingContext.getResponseSuffix());
        String javaType = GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, operationDef.getType(), operationDef.getName(), objectTypeName).getName();
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", MapperUtils.getModelPackageName(mappingContext));
        dataModel.put("annotations", GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, className));
        dataModel.put("className", className);
        dataModel.put("javaDoc", operationDef.getJavaDoc());
        dataModel.put("deprecated", operationDef.isDeprecated());
        dataModel.put("operationName", operationDef.getName());
        dataModel.put("methodName", MapperUtils.capitalizeMethodNameIfRestricted(operationDef.getName()));
        dataModel.put("returnTypeName", javaType);
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        return dataModel;
    }

    public static Map<String, Object> mapRequest(MappingContext mappingContext, ExtendedFieldDefinition operationDef, String objectTypeName, List<String> fieldNames) {
        String className = RequestResponseDefinitionToDataModelMapper.getClassName(operationDef, fieldNames, objectTypeName, mappingContext.getRequestSuffix());
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", MapperUtils.getModelPackageName(mappingContext));
        dataModel.put("annotations", GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, className));
        dataModel.put("className", className);
        dataModel.put("javaDoc", operationDef.getJavaDoc());
        dataModel.put("operationName", operationDef.getName());
        dataModel.put("operationType", objectTypeName.toUpperCase());
        dataModel.put("fields", InputValueDefinitionToParameterMapper.map(mappingContext, operationDef.getInputValueDefinitions(), operationDef.getName()));
        dataModel.put("builder", mappingContext.getGenerateBuilder());
        dataModel.put("equalsAndHashCode", mappingContext.getGenerateEqualsAndHashCode());
        dataModel.put("toString", mappingContext.getGenerateToString());
        dataModel.put("toStringForRequest", mappingContext.getGenerateClient());
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        return dataModel;
    }

    private static String getClassName(ExtendedFieldDefinition operationDef, List<String> fieldNames, String objectType, String suffix) {
        StringBuilder classNameBuilder = new StringBuilder();
        classNameBuilder.append(Utils.capitalize(operationDef.getName()));
        if (Collections.frequency(fieldNames, operationDef.getName()) > 1) {
            classNameBuilder.append(MapperUtils.getClassNameSuffixWithInputValues(operationDef));
        }
        classNameBuilder.append(objectType);
        if (Utils.isNotBlank(suffix)) {
            classNameBuilder.append(suffix);
        }
        return classNameBuilder.toString();
    }

    private static Collection<ProjectionParameterDefinition> getProjectionFields(MappingContext mappingContext, ExtendedDefinition<?, ?> definition) {
        if (definition instanceof ExtendedObjectTypeDefinition) {
            return RequestResponseDefinitionToDataModelMapper.getProjectionFields(mappingContext, (ExtendedObjectTypeDefinition)definition);
        }
        if (definition instanceof ExtendedUnionTypeDefinition) {
            return RequestResponseDefinitionToDataModelMapper.getProjectionFields(mappingContext, (ExtendedUnionTypeDefinition)definition);
        }
        if (definition instanceof ExtendedInterfaceTypeDefinition) {
            return RequestResponseDefinitionToDataModelMapper.getProjectionFields(mappingContext, (ExtendedInterfaceTypeDefinition)definition);
        }
        return Collections.emptyList();
    }

    private static Collection<ProjectionParameterDefinition> getProjectionFields(MappingContext mappingContext, ExtendedObjectTypeDefinition typeDefinition) {
        LinkedHashMap<String, ProjectionParameterDefinition> allParameters = new LinkedHashMap<String, ProjectionParameterDefinition>();
        FieldDefinitionToParameterMapper.mapProjectionFields(mappingContext, typeDefinition.getFieldDefinitions(), typeDefinition).forEach(p -> allParameters.put(p.getMethodName(), (ProjectionParameterDefinition)p));
        List<ExtendedInterfaceTypeDefinition> interfacesOfType = MapperUtils.getInterfacesOfType(typeDefinition, mappingContext.getDocument());
        interfacesOfType.stream().map(i -> FieldDefinitionToParameterMapper.mapProjectionFields(mappingContext, i.getFieldDefinitions(), i)).flatMap(Collection::stream).filter(paramDef -> !allParameters.containsKey(paramDef.getMethodName())).forEach(paramDef -> allParameters.put(paramDef.getMethodName(), (ProjectionParameterDefinition)paramDef));
        ProjectionParameterDefinition typeNameProjParamDef = RequestResponseDefinitionToDataModelMapper.getTypeNameProjectionParameterDefinition();
        allParameters.put(typeNameProjParamDef.getMethodName(), typeNameProjParamDef);
        return allParameters.values();
    }

    private static Collection<ProjectionParameterDefinition> getProjectionFields(MappingContext mappingContext, ExtendedInterfaceTypeDefinition interfaceDefinition) {
        LinkedHashMap<String, ProjectionParameterDefinition> allParameters = new LinkedHashMap<String, ProjectionParameterDefinition>();
        FieldDefinitionToParameterMapper.mapProjectionFields(mappingContext, interfaceDefinition.getFieldDefinitions(), interfaceDefinition).forEach(p -> allParameters.put(p.getMethodName(), (ProjectionParameterDefinition)p));
        MapperUtils.getInterfacesOfType(interfaceDefinition, mappingContext.getDocument()).stream().map(i -> FieldDefinitionToParameterMapper.mapProjectionFields(mappingContext, i.getFieldDefinitions(), i)).flatMap(Collection::stream).filter(paramDef -> !allParameters.containsKey(paramDef.getMethodName())).forEach(paramDef -> allParameters.put(paramDef.getMethodName(), (ProjectionParameterDefinition)paramDef));
        Set interfaceChildren = mappingContext.getInterfaceChildren().getOrDefault(interfaceDefinition.getName(), Collections.emptySet());
        for (String childName : interfaceChildren) {
            ProjectionParameterDefinition childDef = RequestResponseDefinitionToDataModelMapper.getChildDefinition(mappingContext, childName);
            allParameters.put(childDef.getMethodName(), childDef);
        }
        ProjectionParameterDefinition typeNameProjParamDef = RequestResponseDefinitionToDataModelMapper.getTypeNameProjectionParameterDefinition();
        allParameters.put(typeNameProjParamDef.getMethodName(), typeNameProjParamDef);
        return allParameters.values();
    }

    private static Collection<ProjectionParameterDefinition> getProjectionFields(MappingContext mappingContext, ExtendedUnionTypeDefinition unionDefinition) {
        LinkedHashMap<String, ProjectionParameterDefinition> allParameters = new LinkedHashMap<String, ProjectionParameterDefinition>();
        for (String memberTypeName : unionDefinition.getMemberTypeNames()) {
            ProjectionParameterDefinition memberDef = RequestResponseDefinitionToDataModelMapper.getChildDefinition(mappingContext, memberTypeName);
            allParameters.put(memberDef.getMethodName(), memberDef);
        }
        ProjectionParameterDefinition typeNameProjParamDef = RequestResponseDefinitionToDataModelMapper.getTypeNameProjectionParameterDefinition();
        allParameters.put(typeNameProjParamDef.getMethodName(), typeNameProjParamDef);
        return allParameters.values();
    }

    private static ProjectionParameterDefinition getChildDefinition(MappingContext mappingContext, String childName) {
        ProjectionParameterDefinition parameter = new ProjectionParameterDefinition();
        parameter.setName("...on " + childName);
        parameter.setMethodName("on" + childName);
        parameter.setType(Utils.capitalize(childName + mappingContext.getResponseProjectionSuffix()));
        return parameter;
    }

    private static ProjectionParameterDefinition getTypeNameProjectionParameterDefinition() {
        ProjectionParameterDefinition typeNameProjParamDef = new ProjectionParameterDefinition();
        typeNameProjParamDef.setName("__typename");
        typeNameProjParamDef.setMethodName("typename");
        return typeNameProjParamDef;
    }
}

