/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.GraphqlTypeToJavaTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.ParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.ProjectionParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import java.util.List;
import java.util.stream.Collectors;

public class FieldDefinitionToParameterMapper {
    private FieldDefinitionToParameterMapper() {
    }

    public static List<ParameterDefinition> mapFields(MappingContext mappingContext, List<ExtendedFieldDefinition> fieldDefinitions, ExtendedDefinition<?, ?> parentDefinition) {
        return fieldDefinitions.stream().filter(fieldDef -> !FieldDefinitionToParameterMapper.generateResolversForField(mappingContext, fieldDef, parentDefinition)).map(fieldDef -> FieldDefinitionToParameterMapper.mapField(mappingContext, fieldDef, parentDefinition.getName())).collect(Collectors.toList());
    }

    public static List<ProjectionParameterDefinition> mapProjectionFields(MappingContext mappingContext, List<ExtendedFieldDefinition> fieldDefinitions, ExtendedDefinition<?, ?> parentTypeDefinition) {
        return fieldDefinitions.stream().map(fieldDef -> FieldDefinitionToParameterMapper.mapProjectionField(mappingContext, fieldDef, parentTypeDefinition)).collect(Collectors.toList());
    }

    private static ParameterDefinition mapField(MappingContext mappingContext, ExtendedFieldDefinition fieldDef, String parentTypeName) {
        ParameterDefinition parameter = new ParameterDefinition();
        parameter.setName(MapperUtils.capitalizeIfRestricted(fieldDef.getName()));
        parameter.setOriginalName(fieldDef.getName());
        parameter.setType(GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, fieldDef.getType(), fieldDef.getName(), parentTypeName).getName());
        parameter.setAnnotations(GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, fieldDef.getType(), fieldDef, parentTypeName, false));
        parameter.setJavaDoc(fieldDef.getJavaDoc());
        parameter.setDeprecated(fieldDef.isDeprecated());
        return parameter;
    }

    private static ProjectionParameterDefinition mapProjectionField(MappingContext mappingContext, ExtendedFieldDefinition fieldDef, ExtendedDefinition<?, ?> parentTypeDef) {
        ProjectionParameterDefinition parameter = new ProjectionParameterDefinition();
        parameter.setName(fieldDef.getName());
        parameter.setMethodName(MapperUtils.capitalizeMethodNameIfRestricted(parameter.getName()));
        String nestedType = GraphqlTypeToJavaTypeMapper.getNestedTypeName(fieldDef.getType());
        if (mappingContext.getTypesUnionsInterfacesNames().contains(nestedType)) {
            parameter.setType(Utils.capitalize(nestedType + mappingContext.getResponseProjectionSuffix()));
        }
        if (!Utils.isEmpty(fieldDef.getInputValueDefinitions())) {
            parameter.setParametrizedInputClassName(MapperUtils.getParametrizedInputClassName(mappingContext, fieldDef, parentTypeDef));
        }
        parameter.setDeprecated(fieldDef.isDeprecated());
        return parameter;
    }

    public static boolean generateResolversForField(MappingContext mappingContext, ExtendedFieldDefinition fieldDef, ExtendedDefinition<?, ?> parentDefinition) {
        String parentTypeName = parentDefinition.getName();
        boolean noResolverForWholeType = mappingContext.getFieldsWithoutResolvers().contains(parentTypeName);
        boolean noResolverForSpecificField = mappingContext.getFieldsWithoutResolvers().contains(parentTypeName + "." + fieldDef.getName());
        if (noResolverForWholeType || noResolverForSpecificField) {
            return false;
        }
        for (String fieldWithoutResolver : mappingContext.getFieldsWithoutResolvers()) {
            boolean noResolverForWholeTypeViaDirective = parentDefinition.getDirectiveNames().stream().anyMatch(fd -> fieldWithoutResolver.equals("@" + fd));
            boolean noResolverForSpecificFieldViaDirective = fieldDef.getDirectives().stream().anyMatch(fd -> fieldWithoutResolver.equals("@" + fd.getName()));
            if (!noResolverForWholeTypeViaDirective && !noResolverForSpecificFieldViaDirective) continue;
            return false;
        }
        boolean resolverForParamField = mappingContext.getGenerateParameterizedFieldsResolvers() != false && !Utils.isEmpty(fieldDef.getInputValueDefinitions());
        boolean resolverForExtendedType = mappingContext.getGenerateExtensionFieldsResolvers() != false && fieldDef.isFromExtension();
        boolean resolverForWholeType = mappingContext.getFieldsWithResolvers().contains(parentTypeName);
        boolean resolverForTypeField = mappingContext.getFieldsWithResolvers().contains(parentTypeName + "." + fieldDef.getName());
        if (resolverForParamField || resolverForExtendedType || resolverForWholeType || resolverForTypeField) {
            return true;
        }
        for (String fieldWithResolver : mappingContext.getFieldsWithResolvers()) {
            boolean resolverForWholeTypeViaDirective = parentDefinition.getDirectiveNames().stream().anyMatch(fd -> fieldWithResolver.equals("@" + fd));
            boolean resolverForSpecificFieldViaDirective = fieldDef.getDirectives().stream().anyMatch(fd -> fieldWithResolver.equals("@" + fd.getName()));
            if (!resolverForWholeTypeViaDirective && !resolverForSpecificFieldViaDirective) continue;
            return true;
        }
        return false;
    }
}

