/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen;

import com.kobylynskyi.graphql.codegen.FreeMarkerTemplatesRegistry;
import com.kobylynskyi.graphql.codegen.GraphQLCodegenFileCreator;
import com.kobylynskyi.graphql.codegen.GraphQLDocumentParser;
import com.kobylynskyi.graphql.codegen.extension.CodegenContext;
import com.kobylynskyi.graphql.codegen.mapper.EnumDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.FieldDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.FieldDefinitionsToResolverDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphqlTypeToJavaTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.InputDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.InterfaceDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.RequestResponseDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.TypeDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.UnionDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.model.ApiInterfaceStrategy;
import com.kobylynskyi.graphql.codegen.model.ApiNamePrefixStrategy;
import com.kobylynskyi.graphql.codegen.model.ApiRootInterfaceStrategy;
import com.kobylynskyi.graphql.codegen.model.GeneratedInformation;
import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.model.MappingConfigConstants;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDocument;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedEnumTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedInputObjectTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedInterfaceTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedScalarTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedUnionTypeDefinition;
import com.kobylynskyi.graphql.codegen.supplier.MappingConfigSupplier;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.FieldDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class GraphQLCodegen {
    private final List<String> schemas;
    private final String introspectionResult;
    private final File outputDir;
    private final MappingConfig mappingConfig;
    private final GeneratedInformation generatedInformation;

    public GraphQLCodegen(List<String> schemas, File outputDir, MappingConfig mappingConfig, GeneratedInformation generatedInformation) {
        this(schemas, null, outputDir, mappingConfig, null, generatedInformation);
    }

    public GraphQLCodegen(String introspectionResult, File outputDir, MappingConfig mappingConfig, GeneratedInformation generatedInformation) {
        this(null, introspectionResult, outputDir, mappingConfig, null, generatedInformation);
    }

    public GraphQLCodegen(List<String> schemas, String introspectionResult, File outputDir, MappingConfig mappingConfig, MappingConfigSupplier externalMappingConfigSupplier) {
        this(schemas, introspectionResult, outputDir, mappingConfig, externalMappingConfigSupplier, new GeneratedInformation());
    }

    public GraphQLCodegen(List<String> schemas, String introspectionResult, File outputDir, MappingConfig mappingConfig, MappingConfigSupplier externalMappingConfigSupplier, GeneratedInformation generatedInformation) {
        this.schemas = schemas;
        this.introspectionResult = introspectionResult;
        this.outputDir = outputDir;
        this.mappingConfig = mappingConfig;
        this.mappingConfig.combine(externalMappingConfigSupplier != null ? (MappingConfig)externalMappingConfigSupplier.get() : null);
        GraphQLCodegen.initDefaultValues(mappingConfig);
        this.validateConfigs(mappingConfig);
        GraphQLCodegen.sanitizeValues(mappingConfig);
        this.generatedInformation = generatedInformation;
    }

    private static void initDefaultValues(MappingConfig mappingConfig) {
        if (mappingConfig.getModelValidationAnnotation() == null) {
            mappingConfig.setModelValidationAnnotation("javax.validation.constraints.NotNull");
        }
        if (mappingConfig.getGenerateBuilder() == null) {
            mappingConfig.setGenerateBuilder(true);
        }
        if (mappingConfig.getGenerateEqualsAndHashCode() == null) {
            mappingConfig.setGenerateEqualsAndHashCode(false);
        }
        if (mappingConfig.getGenerateClient() == null) {
            mappingConfig.setGenerateClient(false);
        }
        if (mappingConfig.getRequestSuffix() == null) {
            mappingConfig.setRequestSuffix("Request");
        }
        if (mappingConfig.getResponseSuffix() == null) {
            mappingConfig.setResponseSuffix("Response");
        }
        if (mappingConfig.getResponseProjectionSuffix() == null) {
            mappingConfig.setResponseProjectionSuffix("ResponseProjection");
        }
        if (mappingConfig.getParametrizedInputSuffix() == null) {
            mappingConfig.setParametrizedInputSuffix("ParametrizedInput");
        }
        if (mappingConfig.getGenerateImmutableModels() == null) {
            mappingConfig.setGenerateImmutableModels(false);
        }
        if (mappingConfig.getGenerateToString() == null) {
            mappingConfig.setGenerateToString(false);
        }
        if (mappingConfig.getGenerateApis() == null) {
            mappingConfig.setGenerateApis(true);
        }
        if (mappingConfig.getApiNameSuffix() == null) {
            mappingConfig.setApiNameSuffix("Resolver");
        }
        if (mappingConfig.getTypeResolverSuffix() == null) {
            mappingConfig.setTypeResolverSuffix("Resolver");
        }
        if (mappingConfig.getGenerateParameterizedFieldsResolvers() == null) {
            mappingConfig.setGenerateParameterizedFieldsResolvers(true);
        }
        if (mappingConfig.getGenerateExtensionFieldsResolvers() == null) {
            mappingConfig.setGenerateExtensionFieldsResolvers(false);
        }
        if (mappingConfig.getGenerateDataFetchingEnvironmentArgumentInApis() == null) {
            mappingConfig.setGenerateDataFetchingEnvironmentArgumentInApis(false);
        }
        if (mappingConfig.getGenerateModelsForRootTypes() == null) {
            mappingConfig.setGenerateModelsForRootTypes(false);
        }
        if (mappingConfig.getUseOptionalForNullableReturnTypes() == null) {
            mappingConfig.setUseOptionalForNullableReturnTypes(false);
        }
        if (mappingConfig.getApiNamePrefixStrategy() == null) {
            mappingConfig.setApiNamePrefixStrategy(MappingConfigConstants.DEFAULT_API_NAME_PREFIX_STRATEGY);
        }
        if (mappingConfig.getApiRootInterfaceStrategy() == null) {
            mappingConfig.setApiRootInterfaceStrategy(MappingConfigConstants.DEFAULT_API_ROOT_INTERFACE_STRATEGY);
        }
        if (mappingConfig.getApiInterfaceStrategy() == null) {
            mappingConfig.setApiInterfaceStrategy(MappingConfigConstants.DEFAULT_API_INTERFACE_STRATEGY);
        }
        if (Boolean.TRUE.equals(mappingConfig.getGenerateClient())) {
            mappingConfig.setGenerateToString(true);
        }
        if (mappingConfig.getResponseProjectionMaxDepth() == null) {
            mappingConfig.setResponseProjectionMaxDepth(3);
        }
        if (mappingConfig.getGenerateDefaultResolverImpl() == null) {
            mappingConfig.setGenerateDefaultResolverImpl(false);
        }
    }

    private void validateConfigs(MappingConfig mappingConfig) {
        if (!Utils.isEmpty(this.schemas) && this.introspectionResult != null || Utils.isEmpty(this.schemas) && this.introspectionResult == null) {
            throw new IllegalArgumentException("Either graphql schema path or introspection result path should be supplied");
        }
        if (mappingConfig.getApiRootInterfaceStrategy() == ApiRootInterfaceStrategy.INTERFACE_PER_SCHEMA && mappingConfig.getApiNamePrefixStrategy() == ApiNamePrefixStrategy.CONSTANT) {
            throw new IllegalArgumentException("API prefix should not be CONSTANT for INTERFACE_PER_SCHEMA option");
        }
        if (mappingConfig.getGenerateApis().booleanValue() && mappingConfig.getGenerateModelsForRootTypes().booleanValue() && mappingConfig.getApiNamePrefixStrategy() == ApiNamePrefixStrategy.CONSTANT) {
            if (Utils.stringsEqualIgnoreSpaces(mappingConfig.getApiNamePrefix(), mappingConfig.getModelNamePrefix()) && Utils.stringsEqualIgnoreSpaces(mappingConfig.getApiNameSuffix(), mappingConfig.getModelNameSuffix())) {
                throw new IllegalArgumentException("Either disable APIs generation or set different Prefix/Suffix for API classes and model classes");
            }
            if (Utils.stringsEqualIgnoreSpaces(mappingConfig.getApiNamePrefix(), mappingConfig.getTypeResolverPrefix()) && Utils.stringsEqualIgnoreSpaces(mappingConfig.getApiNameSuffix(), mappingConfig.getTypeResolverSuffix())) {
                throw new IllegalArgumentException("Either disable APIs generation or set different Prefix/Suffix for API classes and type resolver classes");
            }
        }
    }

    private static void sanitizeValues(MappingConfig mappingConfig) {
        Map<String, List<String>> directiveAnnotationsMapping;
        mappingConfig.setModelValidationAnnotation(Utils.replaceLeadingAtSign(mappingConfig.getModelValidationAnnotation()));
        Map<String, List<String>> customAnnotationsMapping = mappingConfig.getCustomAnnotationsMapping();
        if (customAnnotationsMapping != null) {
            for (Map.Entry<String, List<String>> entry : customAnnotationsMapping.entrySet()) {
                if (entry.getValue() == null) continue;
                entry.setValue(entry.getValue().stream().map(Utils::replaceLeadingAtSign).collect(Collectors.toList()));
            }
        }
        if ((directiveAnnotationsMapping = mappingConfig.getDirectiveAnnotationsMapping()) != null) {
            for (Map.Entry<String, List<String>> entry : directiveAnnotationsMapping.entrySet()) {
                if (entry.getValue() == null) continue;
                entry.setValue(entry.getValue().stream().map(Utils::replaceLeadingAtSign).collect(Collectors.toList()));
            }
        }
    }

    public List<File> generate() throws IOException {
        GraphQLCodegenFileCreator.prepareOutputDir(this.outputDir);
        long startTime = System.currentTimeMillis();
        List<File> generatedFiles = Collections.emptyList();
        if (!Utils.isEmpty(this.schemas)) {
            ExtendedDocument document = GraphQLDocumentParser.getDocumentFromSchemas(this.mappingConfig, this.schemas);
            this.initCustomTypeMappings(document.getScalarDefinitions());
            generatedFiles = this.processDefinitions(document);
            System.out.println(String.format("Finished processing %d schema(s) in %d ms", this.schemas.size(), System.currentTimeMillis() - startTime));
        } else if (this.introspectionResult != null) {
            ExtendedDocument document = GraphQLDocumentParser.getDocumentFromIntrospectionResult(this.mappingConfig, this.introspectionResult);
            this.initCustomTypeMappings(document.getScalarDefinitions());
            generatedFiles = this.processDefinitions(document);
            System.out.println(String.format("Finished processing introspection result in %d ms", System.currentTimeMillis() - startTime));
        }
        return generatedFiles;
    }

    private List<File> processDefinitions(ExtendedDocument document) {
        MappingContext context = new MappingContext(this.mappingConfig, document, this.generatedInformation);
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (ExtendedObjectTypeDefinition extendedObjectTypeDefinition : document.getTypeDefinitions()) {
            generatedFiles.addAll(this.generateType(context, extendedObjectTypeDefinition));
        }
        for (ExtendedObjectTypeDefinition extendedObjectTypeDefinition : document.getTypeDefinitions()) {
            this.generateFieldResolver(context, extendedObjectTypeDefinition.getFieldDefinitions(), extendedObjectTypeDefinition).ifPresent(generatedFiles::add);
        }
        for (ExtendedInputObjectTypeDefinition extendedInputObjectTypeDefinition : document.getInputDefinitions()) {
            generatedFiles.add(this.generateInput(context, extendedInputObjectTypeDefinition));
        }
        for (ExtendedEnumTypeDefinition extendedEnumTypeDefinition : document.getEnumDefinitions()) {
            generatedFiles.add(this.generateEnum(context, extendedEnumTypeDefinition));
        }
        for (ExtendedUnionTypeDefinition extendedUnionTypeDefinition : document.getUnionDefinitions()) {
            generatedFiles.addAll(this.generateUnion(context, extendedUnionTypeDefinition));
        }
        for (ExtendedInterfaceTypeDefinition extendedInterfaceTypeDefinition : document.getInterfaceDefinitions()) {
            generatedFiles.addAll(this.generateInterface(context, extendedInterfaceTypeDefinition));
        }
        for (ExtendedInterfaceTypeDefinition definition : document.getInterfaceDefinitions()) {
            this.generateFieldResolver(context, definition.getFieldDefinitions(), definition).ifPresent(generatedFiles::add);
        }
        for (ExtendedObjectTypeDefinition extendedObjectTypeDefinition : document.getOperationDefinitions()) {
            if (Boolean.TRUE.equals(this.mappingConfig.getGenerateClient())) {
                generatedFiles.addAll(this.generateClient(context, extendedObjectTypeDefinition));
            }
            if (!Boolean.TRUE.equals(this.mappingConfig.getGenerateApis())) continue;
            generatedFiles.addAll(this.generateServerOperations(context, extendedObjectTypeDefinition));
        }
        System.out.printf("Generated %d definition classes in folder %s%n", generatedFiles.size(), this.outputDir.getAbsolutePath());
        return generatedFiles;
    }

    private List<File> generateUnion(MappingContext mappingContext, ExtendedUnionTypeDefinition definition) {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        Map<String, Object> dataModel = UnionDefinitionToDataModelMapper.map(mappingContext, definition);
        generatedFiles.add(GraphQLCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.unionTemplate, dataModel, this.outputDir));
        if (Boolean.TRUE.equals(this.mappingConfig.getGenerateClient())) {
            Map<String, Object> responseProjDataModel = RequestResponseDefinitionToDataModelMapper.mapResponseProjection(mappingContext, definition);
            generatedFiles.add(GraphQLCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.responseProjectionTemplate, responseProjDataModel, this.outputDir));
        }
        return generatedFiles;
    }

    private List<File> generateInterface(MappingContext mappingContext, ExtendedInterfaceTypeDefinition definition) {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        Map<String, Object> dataModel = InterfaceDefinitionToDataModelMapper.map(mappingContext, definition);
        generatedFiles.add(GraphQLCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.interfaceTemplate, dataModel, this.outputDir));
        if (Boolean.TRUE.equals(this.mappingConfig.getGenerateClient())) {
            Map<String, Object> responseProjDataModel = RequestResponseDefinitionToDataModelMapper.mapResponseProjection(mappingContext, definition);
            generatedFiles.add(GraphQLCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.responseProjectionTemplate, responseProjDataModel, this.outputDir));
            CodegenContext.addEntityProjectionMapping(definition.getName(), (String)responseProjDataModel.get("className"));
            for (ExtendedFieldDefinition fieldDefinition : definition.getFieldDefinitions()) {
                CodegenContext.addOperateProjectionMapping(fieldDefinition.getName(), (String)responseProjDataModel.get("className"));
                if (Utils.isEmpty(fieldDefinition.getInputValueDefinitions())) continue;
                Map<String, Object> fieldProjDataModel = RequestResponseDefinitionToDataModelMapper.mapParametrizedInput(mappingContext, fieldDefinition, definition);
                generatedFiles.add(GraphQLCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.parametrizedInputTemplate, fieldProjDataModel, this.outputDir));
            }
        }
        return generatedFiles;
    }

    private List<File> generateServerOperations(MappingContext mappingContext, ExtendedObjectTypeDefinition definition) {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        switch (mappingContext.getApiRootInterfaceStrategy()) {
            case INTERFACE_PER_SCHEMA: {
                for (ExtendedObjectTypeDefinition defInFile : definition.groupBySourceLocationFile().values()) {
                    generatedFiles.add(this.generateRootApi(mappingContext, defInFile));
                }
                break;
            }
            case DO_NOT_GENERATE: {
                break;
            }
            default: {
                generatedFiles.add(this.generateRootApi(mappingContext, definition));
            }
        }
        if (mappingContext.getApiInterfaceStrategy() == ApiInterfaceStrategy.INTERFACE_PER_OPERATION) {
            List<String> fieldNames = definition.getFieldDefinitions().stream().map(FieldDefinition::getName).collect(Collectors.toList());
            switch (mappingContext.getApiNamePrefixStrategy()) {
                case FOLDER_NAME_AS_PREFIX: {
                    for (ExtendedObjectTypeDefinition fileDef : definition.groupBySourceLocationFolder().values()) {
                        generatedFiles.addAll(this.generateApis(mappingContext, fileDef, fieldNames));
                    }
                    break;
                }
                case FILE_NAME_AS_PREFIX: {
                    for (ExtendedObjectTypeDefinition fileDef : definition.groupBySourceLocationFile().values()) {
                        generatedFiles.addAll(this.generateApis(mappingContext, fileDef, fieldNames));
                    }
                    break;
                }
                default: {
                    generatedFiles.addAll(this.generateApis(mappingContext, definition, fieldNames));
                }
            }
        }
        return generatedFiles;
    }

    private List<File> generateClient(MappingContext mappingContext, ExtendedObjectTypeDefinition definition) {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        List<String> fieldNames = definition.getFieldDefinitions().stream().map(FieldDefinition::getName).collect(Collectors.toList());
        for (ExtendedFieldDefinition operationDef : definition.getFieldDefinitions()) {
            Map<String, Object> requestDataModel = RequestResponseDefinitionToDataModelMapper.mapRequest(mappingContext, operationDef, definition.getName(), fieldNames);
            generatedFiles.add(GraphQLCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.requestTemplate, requestDataModel, this.outputDir));
            Map<String, Object> responseDataModel = RequestResponseDefinitionToDataModelMapper.mapResponse(mappingContext, operationDef, definition.getName(), fieldNames);
            generatedFiles.add(GraphQLCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.responseTemplate, responseDataModel, this.outputDir));
            CodegenContext.addOperateRequestMapping((String)requestDataModel.get("operationName"), (String)requestDataModel.get("className"));
            CodegenContext.addOperateResponseMapping((String)requestDataModel.get("operationName"), (String)responseDataModel.get("className"));
        }
        return generatedFiles;
    }

    private void growingExtension(ExtendedFieldDefinition operationDef, Map<String, Object> dataModel, List<File> generatedFiles, MappingContext mappingContext) {
        if (mappingContext.getGenerateDefaultResolverImpl().booleanValue() && mappingContext.getGenerateClient().booleanValue()) {
            dataModel.put("defaultResolverImplPrefix", "$");
            dataModel.put("operateNameRequestName", CodegenContext.getRequestByOperate(operationDef.getName()));
            dataModel.put("operateNameResponseName", CodegenContext.getResponseByOperate(operationDef.getName()));
            dataModel.put("className", "$" + dataModel.get("className"));
            Set imports = (Set)dataModel.get("imports");
            imports.add((String)dataModel.get("package"));
            String implName = "impl";
            if (dataModel.get("package") != null) {
                implName = dataModel.get("package") + ".impl";
            }
            dataModel.put("package", implName);
            dataModel.put("imports", imports);
            String fieldName = GraphqlTypeToJavaTypeMapper.getNestedTypeName(operationDef.getType());
            String projection = CodegenContext.getProjectionByOperate(operationDef.getName());
            if (projection == null) {
                projection = CodegenContext.getProjectionByEntity(fieldName);
            }
            dataModel.put("operateNameProjectionName", projection);
            if (fieldName != null && !fieldName.equals("Query")) {
                generatedFiles.add(GraphQLCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.operationsDefaultImplementTemplate, dataModel, this.outputDir));
            }
        }
    }

    private List<File> generateApis(MappingContext mappingContext, ExtendedObjectTypeDefinition definition, List<String> fieldNames) {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (ExtendedFieldDefinition operationDef : definition.getFieldDefinitions()) {
            Map<String, Object> dataModel = FieldDefinitionsToResolverDataModelMapper.mapRootTypeField(mappingContext, operationDef, definition.getName(), fieldNames);
            generatedFiles.add(GraphQLCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.operationsTemplate, dataModel, this.outputDir));
            this.growingExtension(operationDef, dataModel, generatedFiles, mappingContext);
        }
        return generatedFiles;
    }

    private File generateRootApi(MappingContext mappingContext, ExtendedObjectTypeDefinition definition) {
        Map<String, Object> dataModel = FieldDefinitionsToResolverDataModelMapper.mapRootTypeFields(mappingContext, definition);
        return GraphQLCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.operationsTemplate, dataModel, this.outputDir);
    }

    private List<File> generateType(MappingContext mappingContext, ExtendedObjectTypeDefinition definition) {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        Map<String, Object> dataModel = TypeDefinitionToDataModelMapper.map(mappingContext, definition);
        generatedFiles.add(GraphQLCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.typeTemplate, dataModel, this.outputDir));
        if (Boolean.TRUE.equals(this.mappingConfig.getGenerateClient())) {
            Map<String, Object> responseProjDataModel = RequestResponseDefinitionToDataModelMapper.mapResponseProjection(mappingContext, definition);
            CodegenContext.addEntityProjectionMapping(definition.getName(), (String)responseProjDataModel.get("className"));
            generatedFiles.add(GraphQLCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.responseProjectionTemplate, responseProjDataModel, this.outputDir));
            for (ExtendedFieldDefinition fieldDefinition : definition.getFieldDefinitions()) {
                if (Utils.isEmpty(fieldDefinition.getInputValueDefinitions())) continue;
                Map<String, Object> fieldProjDataModel = RequestResponseDefinitionToDataModelMapper.mapParametrizedInput(mappingContext, fieldDefinition, definition);
                generatedFiles.add(GraphQLCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.parametrizedInputTemplate, fieldProjDataModel, this.outputDir));
            }
        }
        return generatedFiles;
    }

    private Optional<File> generateFieldResolver(MappingContext mappingContext, List<ExtendedFieldDefinition> fieldDefinitions, ExtendedDefinition<?, ?> parentDefinition) {
        List<ExtendedFieldDefinition> fieldDefsWithResolvers;
        if (Boolean.TRUE.equals(this.mappingConfig.getGenerateApis()) && !(fieldDefsWithResolvers = fieldDefinitions.stream().filter(fieldDef -> FieldDefinitionToParameterMapper.generateResolversForField(mappingContext, fieldDef, parentDefinition)).collect(Collectors.toList())).isEmpty()) {
            Map<String, Object> dataModel = FieldDefinitionsToResolverDataModelMapper.mapToTypeResolver(mappingContext, fieldDefsWithResolvers, parentDefinition.getName());
            return Optional.of(GraphQLCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.operationsTemplate, dataModel, this.outputDir));
        }
        return Optional.empty();
    }

    private File generateInput(MappingContext mappingContext, ExtendedInputObjectTypeDefinition definition) {
        Map<String, Object> dataModel = InputDefinitionToDataModelMapper.map(mappingContext, definition);
        return GraphQLCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.typeTemplate, dataModel, this.outputDir);
    }

    private File generateEnum(MappingContext mappingContext, ExtendedEnumTypeDefinition definition) {
        Map<String, Object> dataModel = EnumDefinitionToDataModelMapper.map(mappingContext, definition);
        return GraphQLCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.enumTemplate, dataModel, this.outputDir);
    }

    private void initCustomTypeMappings(Collection<ExtendedScalarTypeDefinition> scalarTypeDefinitions) {
        for (ExtendedScalarTypeDefinition definition : scalarTypeDefinitions) {
            if (definition.getDefinition() != null) {
                this.mappingConfig.putCustomTypeMappingIfAbsent(((ScalarTypeDefinition)definition.getDefinition()).getName(), "String");
            }
            for (ScalarTypeExtensionDefinition extension : definition.getExtensions()) {
                this.mappingConfig.putCustomTypeMappingIfAbsent(extension.getName(), "String");
            }
        }
        this.mappingConfig.putCustomTypeMappingIfAbsent("ID", "String");
        this.mappingConfig.putCustomTypeMappingIfAbsent("String", "String");
        this.mappingConfig.putCustomTypeMappingIfAbsent("Int", "Integer");
        this.mappingConfig.putCustomTypeMappingIfAbsent("Float", "Double");
        this.mappingConfig.putCustomTypeMappingIfAbsent("Boolean", "Boolean");
    }
}

