package io.github.alleriawindrunner.sdk.v3.transaction.model.bo;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import io.github.alleriawindrunner.sdk.v3.codec.wrapper.ABIDefinition;

public class AbiInfo {

    private Map<String, List<ABIDefinition>> contractFuncAbis;
    private Map<String, ABIDefinition> contractConstructAbi;

    /**
     * create the AbiInfo object
     *
     * @param contractFuncAbis maps between the contract name and the contract abi
     * @param contractConstructAbi maps between the contract name and the constructor abi
     */
    public AbiInfo(
            Map<String, List<ABIDefinition>> contractFuncAbis,
            Map<String, ABIDefinition> contractConstructAbi) {
        super();
        this.contractFuncAbis = contractFuncAbis;
        this.contractConstructAbi = contractConstructAbi;
    }

    public List<ABIDefinition> findFuncAbis(String contractName) {
        List<ABIDefinition> abis = contractFuncAbis.get(contractName);
        if (abis == null) {
            throw new RuntimeException("No such contract abi " + contractName);
        }
        return Collections.unmodifiableList(abis);
    }

    public ABIDefinition findConstructor(String contractName) {
        return contractConstructAbi.get(contractName);
    }
}
