/*
 * Copyright 2014-2020  [fisco-dev]
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package io.github.alleriawindrunner.sdk.v3.eventsub;

import java.util.List;
import io.github.alleriawindrunner.sdk.v3.model.EventLog;

/** Event callback */
public interface EventSubCallback {

    /**
     * onReceiveLog called when sdk receive any response of the target subscription. logs will be
     * parsed by the user through the ABI module.
     *
     * @param eventSubId the event sub task id.
     * @param status the status that peer response to sdk.
     * @param logs logs from the message.
     */
    void onReceiveLog(String eventSubId, int status, List<EventLog> logs);
}
