/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.server.vault;

import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthDerivedKey;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.model.exception.CryptoProviderException;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.crypto.lib.util.AESEncryptionUtils;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;

public class PowerAuthServerVault {
    private final KeyGenerator keyGenerator = new KeyGenerator();
    private final KeyConvertor keyConvertor = new KeyConvertor();

    public byte[] encryptVaultEncryptionKey(PrivateKey serverPrivateKey, PublicKey devicePublicKey, byte[] ctr) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        SecretKey keyMasterSecret = this.keyGenerator.computeSharedKey(serverPrivateKey, devicePublicKey);
        SecretKey keyMasterTransport = this.keyGenerator.deriveSecretKey(keyMasterSecret, PowerAuthDerivedKey.TRANSPORT.getIndex());
        SecretKey keyVaultEncryptionTransport = this.keyGenerator.deriveSecretKey(keyMasterTransport, ctr);
        SecretKey keyVaultEncryption = this.keyGenerator.deriveSecretKey(keyMasterSecret, PowerAuthDerivedKey.ENCRYPTED_VAULT.getIndex());
        byte[] keyVaultEncryptionBytes = this.keyConvertor.convertSharedSecretKeyToBytes(keyVaultEncryption);
        byte[] iv = new byte[16];
        AESEncryptionUtils aes = new AESEncryptionUtils();
        return aes.encrypt(keyVaultEncryptionBytes, iv, keyVaultEncryptionTransport);
    }

    public byte[] encryptVaultEncryptionKey(PrivateKey serverPrivateKey, PublicKey devicePublicKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        SecretKey keyMasterSecret = this.keyGenerator.computeSharedKey(serverPrivateKey, devicePublicKey);
        SecretKey keyTransport = this.keyGenerator.deriveSecretKey(keyMasterSecret, PowerAuthDerivedKey.TRANSPORT.getIndex());
        SecretKey keyVaultEncryption = this.keyGenerator.deriveSecretKey(keyMasterSecret, PowerAuthDerivedKey.ENCRYPTED_VAULT.getIndex());
        byte[] keyVaultEncryptionBytes = this.keyConvertor.convertSharedSecretKeyToBytes(keyVaultEncryption);
        byte[] iv = new byte[16];
        AESEncryptionUtils aes = new AESEncryptionUtils();
        return aes.encrypt(keyVaultEncryptionBytes, iv, keyTransport);
    }
}

