/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.server.util;

import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.model.exception.CryptoProviderException;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataDigest {
    private static final Logger logger = LoggerFactory.getLogger(DataDigest.class);
    private static final int AUTHORIZATION_CODE_LENGTH_MIN = 4;
    private static final int AUTHORIZATION_CODE_LENGTH_MAX = 9;
    private static final int AUTHORIZATION_CODE_LENGTH = 8;
    private final HMACHashUtilities hmac = new HMACHashUtilities();
    private final int authorizationCodeLength;

    public DataDigest() {
        this.authorizationCodeLength = 8;
    }

    public DataDigest(int length) throws GenericCryptoException {
        if (length < 4 || length > 9) {
            throw new GenericCryptoException("Invalid length of the data digest: " + length);
        }
        this.authorizationCodeLength = length;
    }

    public Result generateDigest(List<String> items) {
        if (items.size() == 0) {
            return null;
        }
        try {
            byte[] operationData = String.join((CharSequence)"&", items).getBytes(StandardCharsets.UTF_8);
            byte[] randomKey = new KeyGenerator().generateRandomBytes(16);
            byte[] otpHash = this.hmac.hash(randomKey, operationData);
            BigInteger otp = new BigInteger(otpHash).mod(BigInteger.TEN.pow(this.authorizationCodeLength));
            String digitFormat = "%" + String.format("%02d", this.authorizationCodeLength) + "d";
            String digest = String.format(digitFormat, otp);
            return new Result(digest, randomKey);
        }
        catch (CryptoProviderException | GenericCryptoException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static class Result {
        private final String digest;
        private final byte[] salt;

        Result(String digest, byte[] salt) {
            this.digest = digest;
            this.salt = salt;
        }

        public String getDigest() {
            return this.digest;
        }

        public byte[] getSalt() {
            return this.salt;
        }
    }
}

