/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.server.keyfactory;

import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthDerivedKey;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.model.exception.CryptoProviderException;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;

public class PowerAuthServerKeyFactory {
    private final KeyGenerator keyGenerator = new KeyGenerator();

    public List<SecretKey> keysForSignatureType(PowerAuthSignatureTypes signatureType, SecretKey masterSecretKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        ArrayList<SecretKey> signatureKeys = new ArrayList<SecretKey>();
        if (signatureType == null) {
            return signatureKeys;
        }
        if (signatureType.equals((Object)PowerAuthSignatureTypes.POSSESSION)) {
            SecretKey signatureKey = this.generateServerSignaturePossessionKey(masterSecretKey);
            signatureKeys.add(signatureKey);
        } else if (signatureType.equals((Object)PowerAuthSignatureTypes.KNOWLEDGE)) {
            SecretKey signatureKey = this.generateServerSignatureKnowledgeKey(masterSecretKey);
            signatureKeys.add(signatureKey);
        } else if (signatureType.equals((Object)PowerAuthSignatureTypes.BIOMETRY)) {
            SecretKey signatureKey = this.generateServerSignatureBiometryKey(masterSecretKey);
            signatureKeys.add(signatureKey);
        } else if (signatureType.equals((Object)PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE)) {
            SecretKey signatureKey = this.generateServerSignaturePossessionKey(masterSecretKey);
            signatureKeys.add(signatureKey);
            signatureKey = this.generateServerSignatureKnowledgeKey(masterSecretKey);
            signatureKeys.add(signatureKey);
        } else if (signatureType.equals((Object)PowerAuthSignatureTypes.POSSESSION_BIOMETRY)) {
            SecretKey signatureKey = this.generateServerSignaturePossessionKey(masterSecretKey);
            signatureKeys.add(signatureKey);
            signatureKey = this.generateServerSignatureBiometryKey(masterSecretKey);
            signatureKeys.add(signatureKey);
        } else if (signatureType.equals((Object)PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY)) {
            SecretKey signatureKey = this.generateServerSignaturePossessionKey(masterSecretKey);
            signatureKeys.add(signatureKey);
            signatureKey = this.generateServerSignatureKnowledgeKey(masterSecretKey);
            signatureKeys.add(signatureKey);
            signatureKey = this.generateServerSignatureBiometryKey(masterSecretKey);
            signatureKeys.add(signatureKey);
        }
        return signatureKeys;
    }

    public SecretKey generateServerEncryptedVaultKey(SecretKey masterSecretKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        return this.keyGenerator.deriveSecretKey(masterSecretKey, PowerAuthDerivedKey.ENCRYPTED_VAULT.getIndex());
    }

    public SecretKey generateServerMasterSecretKey(PrivateKey serverPrivateKey, PublicKey devicePublicKey) throws InvalidKeyException, CryptoProviderException {
        return this.keyGenerator.computeSharedKey(serverPrivateKey, devicePublicKey);
    }

    public SecretKey generateServerSignatureBiometryKey(SecretKey masterSecretKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        return this.keyGenerator.deriveSecretKey(masterSecretKey, PowerAuthDerivedKey.SIGNATURE_BIOMETRY.getIndex());
    }

    public SecretKey generateServerSignatureKnowledgeKey(SecretKey masterSecretKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        return this.keyGenerator.deriveSecretKey(masterSecretKey, PowerAuthDerivedKey.SIGNATURE_KNOWLEDGE.getIndex());
    }

    public SecretKey generateServerSignaturePossessionKey(SecretKey masterSecretKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        return this.keyGenerator.deriveSecretKey(masterSecretKey, PowerAuthDerivedKey.SIGNATURE_POSSESSION.getIndex());
    }

    public SecretKey generateServerTransportKey(SecretKey masterSecretKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        return this.keyGenerator.deriveSecretKey(masterSecretKey, PowerAuthDerivedKey.TRANSPORT.getIndex());
    }

    public SecretKey deriveTransportKey(PrivateKey serverPrivateKey, PublicKey devicePublicKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        SecretKey masterSecretKey = this.generateServerMasterSecretKey(serverPrivateKey, devicePublicKey);
        return this.generateServerTransportKey(masterSecretKey);
    }
}

