/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.server.activation;

import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.lib.generator.IdentifierGenerator;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.model.ActivationStatusBlobInfo;
import io.getlime.security.powerauth.crypto.lib.model.ActivationVersion;
import io.getlime.security.powerauth.crypto.lib.model.exception.CryptoProviderException;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.crypto.lib.util.AESEncryptionUtils;
import io.getlime.security.powerauth.crypto.lib.util.ECPublicKeyFingerprint;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import io.getlime.security.powerauth.crypto.lib.util.HashBasedCounterUtils;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.crypto.lib.util.KeyDerivationUtils;
import io.getlime.security.powerauth.crypto.lib.util.SignatureUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerAuthServerActivation {
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthServerActivation.class);
    private final IdentifierGenerator identifierGenerator = new IdentifierGenerator();
    private final SignatureUtils signatureUtils = new SignatureUtils();
    private final KeyGenerator keyGenerator = new KeyGenerator();
    private final KeyConvertor keyConvertor = new KeyConvertor();

    public String generateActivationId() {
        return this.identifierGenerator.generateActivationId();
    }

    public String generateActivationCode() throws CryptoProviderException {
        return this.identifierGenerator.generateActivationCode();
    }

    public KeyPair generateServerKeyPair() throws CryptoProviderException {
        return this.keyGenerator.generateKeyPair();
    }

    public byte[] generateActivationSignature(String activationCode, PrivateKey masterPrivateKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        byte[] bytes = activationCode.getBytes(StandardCharsets.UTF_8);
        return this.signatureUtils.computeECDSASignature(bytes, masterPrivateKey);
    }

    public byte[] generateActivationNonce() throws CryptoProviderException {
        return this.keyGenerator.generateRandomBytes(16);
    }

    public boolean validateApplicationSignature(String activationIdShort, byte[] activationNonce, byte[] encryptedDevicePublicKey, byte[] applicationKey, byte[] applicationSecret, byte[] signature) throws GenericCryptoException, CryptoProviderException {
        String signatureBaseString = activationIdShort + "&" + BaseEncoding.base64().encode(activationNonce) + "&" + BaseEncoding.base64().encode(encryptedDevicePublicKey) + "&" + BaseEncoding.base64().encode(applicationKey);
        byte[] signatureExpected = new HMACHashUtilities().hash(applicationSecret, signatureBaseString.getBytes(StandardCharsets.UTF_8));
        return Arrays.equals(signatureExpected, signature);
    }

    public PublicKey decryptDevicePublicKey(byte[] C_devicePublicKey, String activationIdShort, PrivateKey masterPrivateKey, PublicKey ephemeralPublicKey, String activationOTP, byte[] activationNonce) throws GenericCryptoException, CryptoProviderException {
        try {
            byte[] activationIdShortBytes = activationIdShort.getBytes(StandardCharsets.UTF_8);
            SecretKey otpBasedSymmetricKey = this.keyGenerator.deriveSecretKeyFromPassword(activationOTP, activationIdShortBytes);
            if (ephemeralPublicKey != null) {
                SecretKey ephemeralSymmetricKey = this.keyGenerator.computeSharedKey(masterPrivateKey, ephemeralPublicKey);
                AESEncryptionUtils aes = new AESEncryptionUtils();
                byte[] decryptedTMP = aes.decrypt(C_devicePublicKey, activationNonce, ephemeralSymmetricKey);
                byte[] decryptedPublicKeyBytes = aes.decrypt(decryptedTMP, activationNonce, otpBasedSymmetricKey);
                return this.keyConvertor.convertBytesToPublicKey(decryptedPublicKeyBytes);
            }
            AESEncryptionUtils aes = new AESEncryptionUtils();
            byte[] decryptedPublicKeyBytes = aes.decrypt(C_devicePublicKey, activationNonce, otpBasedSymmetricKey);
            return this.keyConvertor.convertBytesToPublicKey(decryptedPublicKeyBytes);
        }
        catch (InvalidKeyException | InvalidKeySpecException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new GenericCryptoException(ex.getMessage(), ex);
        }
    }

    public byte[] encryptServerPublicKey(PublicKey serverPublicKey, PublicKey devicePublicKey, PrivateKey ephemeralPrivateKey, String activationOTP, String activationIdShort, byte[] activationNonce) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        byte[] serverPublicKeyBytes = this.keyConvertor.convertPublicKeyToBytes(serverPublicKey);
        SecretKey ephemeralSymmetricKey = this.keyGenerator.computeSharedKey(ephemeralPrivateKey, devicePublicKey);
        byte[] activationIdShortBytes = activationIdShort.getBytes(StandardCharsets.UTF_8);
        SecretKey otpBasedSymmetricKey = this.keyGenerator.deriveSecretKeyFromPassword(activationOTP, activationIdShortBytes);
        AESEncryptionUtils aes = new AESEncryptionUtils();
        byte[] encryptedTmp = aes.encrypt(serverPublicKeyBytes, activationNonce, otpBasedSymmetricKey);
        return aes.encrypt(encryptedTmp, activationNonce, ephemeralSymmetricKey);
    }

    public byte[] encryptedStatusBlob(ActivationStatusBlobInfo statusBlobInfo, byte[] challenge, byte[] nonce, SecretKey transportKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        byte ctrLookAhead;
        byte ctrByte;
        byte[] ctrDataHash;
        byte[] reserved;
        if (statusBlobInfo == null) {
            throw new GenericCryptoException("Required statusBlobInfo parameter is missing");
        }
        if (transportKey == null) {
            throw new GenericCryptoException("Required transportKey parameter is missing");
        }
        if (challenge != null) {
            if (statusBlobInfo.getCtrDataHash() == null) {
                throw new GenericCryptoException("Missing ctrDataHash in statusBlobInfo object");
            }
            reserved = this.keyGenerator.generateRandomBytes(5);
            ctrDataHash = statusBlobInfo.getCtrDataHash();
            ctrByte = statusBlobInfo.getCtrByte();
            ctrLookAhead = statusBlobInfo.getCtrLookAhead();
        } else {
            byte[] randomBytes = this.keyGenerator.generateRandomBytes(23);
            reserved = Arrays.copyOf(randomBytes, 5);
            ctrDataHash = Arrays.copyOfRange(randomBytes, 7, 23);
            ctrByte = randomBytes[5];
            ctrLookAhead = randomBytes[6];
        }
        byte[] statusBlob = ByteBuffer.allocate(32).putInt(-557785391).put(statusBlobInfo.getActivationStatus()).put(statusBlobInfo.getCurrentVersion()).put(statusBlobInfo.getUpgradeVersion()).put(reserved).put(ctrByte).put(statusBlobInfo.getFailedAttempts()).put(statusBlobInfo.getMaxFailedAttempts()).put(ctrLookAhead).put(ctrDataHash).array();
        byte[] iv = new KeyDerivationUtils().deriveIvForStatusBlobEncryption(challenge, nonce, transportKey);
        return new AESEncryptionUtils().encrypt(statusBlob, iv, transportKey, "AES/CBC/NoPadding");
    }

    public byte[] calculateHashFromHashBasedCounter(byte[] ctrData, SecretKey transportKey) throws CryptoProviderException, InvalidKeyException, GenericCryptoException {
        return new HashBasedCounterUtils().calculateHashFromHashBasedCounter(ctrData, transportKey);
    }

    public byte[] computeServerDataSignature(String activationId, byte[] C_serverPublicKey, PrivateKey masterPrivateKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        byte[] activationIdBytes = activationId.getBytes(StandardCharsets.UTF_8);
        String activationIdBytesBase64 = BaseEncoding.base64().encode(activationIdBytes);
        String C_serverPublicKeyBase64 = BaseEncoding.base64().encode(C_serverPublicKey);
        byte[] result = (activationIdBytesBase64 + "&" + C_serverPublicKeyBase64).getBytes(StandardCharsets.UTF_8);
        return this.signatureUtils.computeECDSASignature(result, masterPrivateKey);
    }

    public String computeActivationFingerprint(PublicKey devicePublicKey) throws GenericCryptoException, CryptoProviderException {
        return this.computeActivationFingerprint(devicePublicKey, null, null, ActivationVersion.VERSION_2);
    }

    public String computeActivationFingerprint(PublicKey devicePublicKey, PublicKey serverPublicKey, String activationId) throws GenericCryptoException, CryptoProviderException {
        return this.computeActivationFingerprint(devicePublicKey, serverPublicKey, activationId, ActivationVersion.VERSION_3);
    }

    public String computeActivationFingerprint(PublicKey devicePublicKey, PublicKey serverPublicKey, String activationId, ActivationVersion activationVersion) throws GenericCryptoException, CryptoProviderException {
        return ECPublicKeyFingerprint.compute((ECPublicKey)devicePublicKey, (ECPublicKey)serverPublicKey, activationId, activationVersion);
    }
}

