/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.util;

import com.google.common.base.Joiner;
import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureFormat;
import io.getlime.security.powerauth.crypto.lib.model.exception.CryptoProviderException;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureUtils {
    private static final Logger logger = LoggerFactory.getLogger(SignatureUtils.class);

    public byte[] computeECDSASignature(byte[] bytes, PrivateKey masterPrivateKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        try {
            Signature ecdsa = Signature.getInstance("SHA256withECDSA", "BC");
            ecdsa.initSign(masterPrivateKey);
            ecdsa.update(bytes);
            return ecdsa.sign();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new CryptoProviderException(ex.getMessage(), ex);
        }
        catch (SignatureException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new GenericCryptoException(ex.getMessage(), ex);
        }
    }

    public boolean validateECDSASignature(byte[] signedBytes, byte[] signature, PublicKey masterPublicKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        try {
            Signature ecdsa = Signature.getInstance("SHA256withECDSA", "BC");
            ecdsa.initVerify(masterPublicKey);
            ecdsa.update(signedBytes);
            return ecdsa.verify(signature);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new CryptoProviderException(ex.getMessage(), ex);
        }
        catch (SignatureException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new GenericCryptoException(ex.getMessage(), ex);
        }
    }

    private String computePowerAuthDecimalSignature(byte[] data, List<SecretKey> signatureKeys, byte[] ctrData) throws GenericCryptoException, CryptoProviderException {
        Object[] signatureStringComponents = new String[signatureKeys.size()];
        List<byte[]> signatureComponents = this.computePowerAuthSignatureComponents(data, signatureKeys, ctrData);
        for (int i = 0; i < signatureComponents.size(); ++i) {
            byte[] signatureComponent = signatureComponents.get(i);
            int index = signatureComponent.length - 4;
            int number = (ByteBuffer.wrap(signatureComponent).getInt(index) & Integer.MAX_VALUE) % (int)Math.pow(10.0, 8.0);
            signatureStringComponents[i] = String.format("%08d", number);
        }
        return Joiner.on((String)"-").join(signatureStringComponents);
    }

    private String computePowerAuthBase64Signature(byte[] data, List<SecretKey> signatureKeys, byte[] ctrData) throws GenericCryptoException, CryptoProviderException {
        byte[] signatureBytes = new byte[signatureKeys.size() * 16];
        List<byte[]> signatureComponents = this.computePowerAuthSignatureComponents(data, signatureKeys, ctrData);
        for (int i = 0; i < signatureComponents.size(); ++i) {
            byte[] signatureComponent = signatureComponents.get(i);
            int sourceOffset = signatureComponent.length - 16;
            int destinationOffset = i * 16;
            System.arraycopy(signatureComponent, sourceOffset, signatureBytes, destinationOffset, 16);
        }
        return BaseEncoding.base64().encode(signatureBytes);
    }

    private List<byte[]> computePowerAuthSignatureComponents(byte[] data, List<SecretKey> signatureKeys, byte[] ctrData) throws GenericCryptoException, CryptoProviderException {
        HMACHashUtilities hmac = new HMACHashUtilities();
        ArrayList<byte[]> signatureComponents = new ArrayList<byte[]>();
        KeyConvertor keyConvertor = new KeyConvertor();
        for (int i = 0; i < signatureKeys.size(); ++i) {
            byte[] signatureKey = keyConvertor.convertSharedSecretKeyToBytes(signatureKeys.get(i));
            byte[] derivedKey = hmac.hash(signatureKey, ctrData);
            for (int j = 0; j < i; ++j) {
                byte[] signatureKeyInner = keyConvertor.convertSharedSecretKeyToBytes(signatureKeys.get(j + 1));
                byte[] derivedKeyInner = hmac.hash(signatureKeyInner, ctrData);
                derivedKey = hmac.hash(derivedKeyInner, derivedKey);
            }
            byte[] signatureBytes = hmac.hash(derivedKey, data);
            if (signatureBytes.length < 16) {
                throw new IndexOutOfBoundsException();
            }
            signatureComponents.add(signatureBytes);
        }
        return signatureComponents;
    }

    public String computePowerAuthSignature(byte[] data, List<SecretKey> signatureKeys, byte[] ctrData, PowerAuthSignatureFormat format) throws GenericCryptoException, CryptoProviderException {
        if (signatureKeys == null) {
            throw new GenericCryptoException("Missing signatureKeys parameter");
        }
        if (ctrData == null) {
            throw new GenericCryptoException("Missing ctrData parameter");
        }
        if (signatureKeys.isEmpty() || signatureKeys.size() > 3) {
            throw new GenericCryptoException("Wrong number of signature keys");
        }
        if (ctrData.length != 16) {
            throw new GenericCryptoException("Invalid length of signature counter");
        }
        switch (format) {
            case BASE64: {
                return this.computePowerAuthBase64Signature(data, signatureKeys, ctrData);
            }
            case DECIMAL: {
                return this.computePowerAuthDecimalSignature(data, signatureKeys, ctrData);
            }
        }
        throw new GenericCryptoException("Unsupported format of PowerAuth signature.");
    }

    public boolean validatePowerAuthSignature(byte[] data, String signature, List<SecretKey> signatureKeys, byte[] ctrData, PowerAuthSignatureFormat format) throws GenericCryptoException, CryptoProviderException {
        return signature.equals(this.computePowerAuthSignature(data, signatureKeys, ctrData, format));
    }
}

