/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.util;

import io.getlime.security.powerauth.crypto.lib.model.exception.CryptoProviderException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyConvertor {
    private static final Logger logger = LoggerFactory.getLogger(KeyConvertor.class);

    public byte[] convertPublicKeyToBytes(PublicKey publicKey) throws CryptoProviderException {
        ECPoint ecPoint = ((ECPublicKey)publicKey).getW();
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
        if (ecSpec == null) {
            throw new CryptoProviderException("Crypto provider does not support the secp256r1 curve");
        }
        org.bouncycastle.math.ec.ECPoint point = ecSpec.getCurve().createPoint(ecPoint.getAffineX(), ecPoint.getAffineY());
        return point.getEncoded(false);
    }

    public PublicKey convertBytesToPublicKey(byte[] keyBytes) throws InvalidKeySpecException, CryptoProviderException {
        try {
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
            if (ecSpec == null) {
                throw new CryptoProviderException("Crypto provider does not support the secp256r1 curve");
            }
            org.bouncycastle.math.ec.ECPoint point = ecSpec.getCurve().decodePoint(keyBytes);
            BigInteger x = point.getAffineXCoord().toBigInteger();
            BigInteger y = point.getAffineYCoord().toBigInteger();
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC", "BC");
            parameters.init(new ECGenParameterSpec("secp256r1"));
            ECParameterSpec ecParameterSpec = parameters.getParameterSpec(ECParameterSpec.class);
            ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(new ECPoint(x, y), ecParameterSpec);
            return KeyFactory.getInstance("EC", "BC").generatePublic(ecPublicKeySpec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidParameterSpecException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new CryptoProviderException(ex.getMessage(), ex);
        }
    }

    public byte[] convertPrivateKeyToBytes(PrivateKey privateKey) {
        return ((ECPrivateKey)privateKey).getS().toByteArray();
    }

    public PrivateKey convertBytesToPrivateKey(byte[] keyBytes) throws InvalidKeySpecException, CryptoProviderException {
        try {
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC", "BC");
            parameters.init(new ECGenParameterSpec("secp256r1"));
            ECParameterSpec ecParameterSpec = parameters.getParameterSpec(ECParameterSpec.class);
            ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(new BigInteger(keyBytes), ecParameterSpec);
            return KeyFactory.getInstance("EC", "BC").generatePrivate(ecPrivateKeySpec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidParameterSpecException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new CryptoProviderException(ex.getMessage(), ex);
        }
    }

    public byte[] convertSharedSecretKeyToBytes(SecretKey sharedSecretKey) {
        return sharedSecretKey.getEncoded();
    }

    public SecretKey convertBytesToSharedSecretKey(byte[] bytesSecretKey) {
        return new SecretKeySpec(bytesSecretKey, "AES");
    }
}

