/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.util;

import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.model.exception.CryptoProviderException;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.util.Arrays;
import javax.crypto.SecretKey;

public class HashBasedCounterUtils {
    private final KeyGenerator keyGenerator = new KeyGenerator();
    private final KeyConvertor keyConvertor = new KeyConvertor();
    private static final long STATUS_BLOB_TRANSPORT_CTR_INDEX = 4000L;
    private static final int STATUS_BLOB_TRANSPORT_CTR_LENGTH = 16;
    private static final int CTR_DATA_LENGTH = 16;

    public byte[] calculateHashFromHashBasedCounter(byte[] ctrData, SecretKey transportKey) throws CryptoProviderException, InvalidKeyException, GenericCryptoException {
        if (ctrData == null || ctrData.length != 16) {
            throw new GenericCryptoException("Invalid ctrData provided");
        }
        if (transportKey == null) {
            throw new GenericCryptoException("Invalid transport key");
        }
        byte[] derivationIndex = ByteBuffer.allocate(16).putLong(0L).putLong(4000L).array();
        SecretKey transportCtr = this.keyGenerator.deriveSecretKey(transportKey, derivationIndex);
        SecretKey ctrDataHashKey = this.keyGenerator.deriveSecretKeyHmac(transportCtr, ctrData);
        return this.keyConvertor.convertSharedSecretKeyToBytes(ctrDataHashKey);
    }

    public boolean verifyHashForHashBasedCounter(byte[] receivedCtrDataHash, byte[] expectedCtrData, SecretKey transportKey) throws CryptoProviderException, InvalidKeyException, GenericCryptoException {
        if (expectedCtrData == null || expectedCtrData.length != 16) {
            throw new GenericCryptoException("Invalid expected counter data");
        }
        if (receivedCtrDataHash == null || receivedCtrDataHash.length != 16) {
            throw new GenericCryptoException("Invalid received counter data hash");
        }
        if (transportKey == null) {
            throw new GenericCryptoException("Invalid transport key");
        }
        byte[] expectedCtrDataHash = this.calculateHashFromHashBasedCounter(expectedCtrData, transportKey);
        return Arrays.equals(expectedCtrDataHash, receivedCtrDataHash);
    }
}

