/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.util;

import io.getlime.security.powerauth.crypto.lib.model.exception.CryptoProviderException;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESEncryptionUtils {
    private static final Logger logger = LoggerFactory.getLogger(AESEncryptionUtils.class);

    public byte[] encrypt(byte[] bytes, byte[] iv, SecretKey secret, String transformation) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        try {
            Cipher cipherForCryptoResponse = Cipher.getInstance(transformation, "BC");
            cipherForCryptoResponse.init(1, (Key)secret, new IvParameterSpec(iv));
            return cipherForCryptoResponse.doFinal(bytes);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new CryptoProviderException(ex.getMessage(), ex);
        }
        catch (BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new GenericCryptoException(ex.getMessage(), ex);
        }
    }

    public byte[] encrypt(byte[] bytes, byte[] iv, SecretKey secret) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        return this.encrypt(bytes, iv, secret, "AES/CBC/PKCS7Padding");
    }

    public byte[] decrypt(byte[] bytes, byte[] iv, SecretKey secret, String transformation) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        try {
            Cipher cipherForCryptoResponse = Cipher.getInstance(transformation, "BC");
            cipherForCryptoResponse.init(2, (Key)secret, new IvParameterSpec(iv));
            return cipherForCryptoResponse.doFinal(bytes);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new CryptoProviderException(ex.getMessage(), ex);
        }
        catch (BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new GenericCryptoException(ex.getMessage(), ex);
        }
    }

    public byte[] decrypt(byte[] bytes, byte[] iv, SecretKey secret) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        return this.decrypt(bytes, iv, secret, "AES/CBC/PKCS7Padding");
    }
}

