/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.enums;

import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import java.util.HashMap;
import java.util.Map;

public enum PowerAuthSignatureFormat {
    DECIMAL,
    BASE64;

    private static final Map<String, PowerAuthSignatureFormat> stringToEnumMap;
    private static final Map<String, PowerAuthSignatureFormat> versionToEnumMap;

    public static PowerAuthSignatureFormat getFormatForSignatureVersion(String signatureVersion) throws GenericCryptoException {
        if (signatureVersion != null) {
            PowerAuthSignatureFormat signatureFormat = versionToEnumMap.get(signatureVersion);
            if (signatureFormat != null) {
                return signatureFormat;
            }
            try {
                double numericVersion = Double.parseDouble(signatureVersion);
                if (numericVersion > 3.1) {
                    return BASE64;
                }
            }
            catch (NumberFormatException ex) {
                throw new GenericCryptoException("Unsupported signature version: " + signatureVersion, ex);
            }
            throw new GenericCryptoException("Unsupported signature version: " + signatureVersion);
        }
        throw new GenericCryptoException("Unspecified signature version");
    }

    public static PowerAuthSignatureFormat getEnumFromString(String value) {
        if (value != null) {
            return stringToEnumMap.get(value.toUpperCase());
        }
        return null;
    }

    public boolean equalsName(String otherName) {
        return this.toString().equalsIgnoreCase(otherName);
    }

    static {
        stringToEnumMap = new HashMap<String, PowerAuthSignatureFormat>();
        versionToEnumMap = new HashMap<String, PowerAuthSignatureFormat>();
        for (PowerAuthSignatureFormat format : PowerAuthSignatureFormat.values()) {
            stringToEnumMap.put(format.toString(), format);
        }
        versionToEnumMap.put("2.0", DECIMAL);
        versionToEnumMap.put("2.1", DECIMAL);
        versionToEnumMap.put("3.0", DECIMAL);
        versionToEnumMap.put("3.1", BASE64);
    }
}

