/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.encryptor.ecies;

import com.google.common.primitives.Bytes;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesEnvelopeKey;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.exception.EciesException;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesCryptogram;
import io.getlime.security.powerauth.crypto.lib.model.exception.CryptoProviderException;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.crypto.lib.util.AESEncryptionUtils;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.util.Arrays;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EciesDecryptor {
    private static final Logger logger = LoggerFactory.getLogger(EciesDecryptor.class);
    private final AESEncryptionUtils aes = new AESEncryptionUtils();
    private final HMACHashUtilities hmac = new HMACHashUtilities();
    private final KeyConvertor keyConvertor = new KeyConvertor();
    private final PrivateKey privateKey;
    private final byte[] sharedInfo1;
    private final byte[] sharedInfo2;
    private EciesEnvelopeKey envelopeKey;
    private boolean canDecryptData;
    private boolean canEncryptData;
    private byte[] ivForEncryption;

    public EciesDecryptor(ECPrivateKey encryptionPrivateKey) {
        this(encryptionPrivateKey, null, null);
    }

    public EciesDecryptor(ECPrivateKey encryptionPrivateKey, byte[] sharedInfo1, byte[] sharedInfo2) {
        this.privateKey = encryptionPrivateKey;
        this.sharedInfo1 = sharedInfo1;
        this.sharedInfo2 = sharedInfo2;
        this.canDecryptData = true;
        this.canEncryptData = false;
    }

    public EciesDecryptor(EciesEnvelopeKey envelopeKey, byte[] sharedInfo2) {
        this.privateKey = null;
        this.envelopeKey = envelopeKey;
        this.sharedInfo1 = null;
        this.sharedInfo2 = sharedInfo2;
        this.canDecryptData = true;
        this.canEncryptData = false;
    }

    public void initEnvelopeKey(byte[] ephemeralPublicKeyBytes) throws EciesException {
        this.envelopeKey = EciesEnvelopeKey.fromPrivateKey(this.privateKey, ephemeralPublicKeyBytes, this.sharedInfo1);
        this.canDecryptData = false;
        this.canEncryptData = true;
        this.ivForEncryption = new byte[16];
    }

    public byte[] decryptRequest(EciesCryptogram cryptogram, boolean requireIv) throws EciesException {
        if (cryptogram == null || cryptogram.getEncryptedData() == null || cryptogram.getMac() == null || this.envelopeKey == null && cryptogram.getEphemeralPublicKey() == null) {
            throw new EciesException("Parameter cryptogram for request decryption is invalid");
        }
        if (requireIv && cryptogram.getNonce() == null) {
            throw new EciesException("Nonce parameter in cryptogram is invalid.");
        }
        if (!this.canDecryptRequest()) {
            throw new EciesException("Request decryption is not allowed");
        }
        if (this.envelopeKey == null) {
            this.envelopeKey = EciesEnvelopeKey.fromPrivateKey(this.privateKey, cryptogram.getEphemeralPublicKey(), this.sharedInfo1);
        }
        return this.decrypt(cryptogram, requireIv);
    }

    public byte[] decryptRequest(EciesCryptogram cryptogram) throws EciesException {
        return this.decryptRequest(cryptogram, cryptogram.getNonce() != null);
    }

    public EciesCryptogram encryptResponse(byte[] data) throws EciesException {
        if (data == null) {
            throw new EciesException("Parameter data for response encryption is null");
        }
        if (!this.canEncryptResponse()) {
            throw new EciesException("Response encryption is not allowed");
        }
        return this.encrypt(data);
    }

    public byte[] getSharedInfo2() {
        return this.sharedInfo2;
    }

    public EciesEnvelopeKey getEnvelopeKey() {
        return this.envelopeKey;
    }

    private boolean canDecryptRequest() {
        return this.canDecryptData && (this.privateKey != null || this.envelopeKey != null && this.envelopeKey.isValid());
    }

    private boolean canEncryptResponse() {
        return this.canEncryptData && this.envelopeKey.isValid() && this.ivForEncryption != null;
    }

    private byte[] decrypt(EciesCryptogram cryptogram, boolean requireIv) throws EciesException {
        try {
            byte[] macData = this.sharedInfo2 == null ? cryptogram.getEncryptedData() : Bytes.concat((byte[][])new byte[][]{cryptogram.getEncryptedData(), this.sharedInfo2});
            byte[] mac = this.hmac.hash(this.envelopeKey.getMacKey(), macData);
            if (!Arrays.equals(mac, cryptogram.getMac())) {
                throw new EciesException("Invalid MAC");
            }
            byte[] encKeyBytes = this.envelopeKey.getEncKey();
            SecretKey encKey = this.keyConvertor.convertBytesToSharedSecretKey(encKeyBytes);
            byte[] iv = requireIv ? this.envelopeKey.deriveIvForNonce(cryptogram.getNonce()) : new byte[16];
            this.canDecryptData = false;
            this.canEncryptData = true;
            this.ivForEncryption = iv;
            return this.aes.decrypt(cryptogram.getEncryptedData(), iv, encKey);
        }
        catch (CryptoProviderException | GenericCryptoException | InvalidKeyException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new EciesException("Request decryption failed", ex);
        }
    }

    private EciesCryptogram encrypt(byte[] data) throws EciesException {
        try {
            byte[] encKeyBytes = this.envelopeKey.getEncKey();
            SecretKey encKey = this.keyConvertor.convertBytesToSharedSecretKey(encKeyBytes);
            byte[] iv = this.ivForEncryption;
            byte[] body = this.aes.encrypt(data, iv, encKey);
            byte[] macData = this.sharedInfo2 == null ? body : Bytes.concat((byte[][])new byte[][]{body, this.sharedInfo2});
            byte[] mac = this.hmac.hash(this.envelopeKey.getMacKey(), macData);
            this.canEncryptData = false;
            this.ivForEncryption = null;
            return new EciesCryptogram(mac, body);
        }
        catch (CryptoProviderException | GenericCryptoException | InvalidKeyException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new EciesException("Response encryption failed", ex);
        }
    }
}

