/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.client.vault;

import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.model.exception.CryptoProviderException;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.crypto.lib.util.AESEncryptionUtils;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;

public class PowerAuthClientVault {
    private final KeyConvertor keyConvertor = new KeyConvertor();

    public SecretKey decryptVaultEncryptionKey(byte[] cVaultEncryptionKey, SecretKey masterTransportKey, byte[] ctr) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        AESEncryptionUtils aes = new AESEncryptionUtils();
        KeyGenerator keyGen = new KeyGenerator();
        SecretKey vaultEncryptionTransportKey = keyGen.deriveSecretKey(masterTransportKey, ctr);
        byte[] zeroBytes = new byte[16];
        byte[] keyBytes = aes.decrypt(cVaultEncryptionKey, zeroBytes, vaultEncryptionTransportKey);
        return this.keyConvertor.convertBytesToSharedSecretKey(keyBytes);
    }

    public SecretKey decryptVaultEncryptionKey(byte[] cVaultEncryptionKey, SecretKey transportKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        AESEncryptionUtils aes = new AESEncryptionUtils();
        byte[] zeroBytes = new byte[16];
        byte[] keyBytes = aes.decrypt(cVaultEncryptionKey, zeroBytes, transportKey);
        return this.keyConvertor.convertBytesToSharedSecretKey(keyBytes);
    }

    public byte[] encryptDevicePrivateKey(PrivateKey devicePrivateKey, SecretKey vaultEncryptionKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        AESEncryptionUtils aes = new AESEncryptionUtils();
        byte[] devicePrivateKeyBytes = this.keyConvertor.convertPrivateKeyToBytes(devicePrivateKey);
        byte[] zeroBytes = new byte[16];
        return aes.encrypt(devicePrivateKeyBytes, zeroBytes, vaultEncryptionKey);
    }

    public PrivateKey decryptDevicePrivateKey(byte[] cDevicePrivateKey, SecretKey vaultEncryptionKey) throws InvalidKeyException, InvalidKeySpecException, GenericCryptoException, CryptoProviderException {
        AESEncryptionUtils aes = new AESEncryptionUtils();
        byte[] zeroBytes = new byte[16];
        byte[] keyBytes = aes.decrypt(cDevicePrivateKey, zeroBytes, vaultEncryptionKey);
        return this.keyConvertor.convertBytesToPrivateKey(keyBytes);
    }
}

