/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.client.encryptor;

import io.getlime.security.powerauth.crypto.lib.encryptor.NonPersonalizedEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.NonPersonalizedEncryptedMessage;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.model.exception.CryptoProviderException;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PublicKey;
import javax.crypto.SecretKey;

public class ClientNonPersonalizedEncryptor {
    private NonPersonalizedEncryptor encryptor;
    private final KeyConvertor keyConvertor = new KeyConvertor();

    public ClientNonPersonalizedEncryptor(byte[] appKey, PublicKey masterPublicKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        KeyGenerator generator = new KeyGenerator();
        byte[] sessionIndex = generator.generateRandomBytes(16);
        KeyPair ephemeralKeyPair = generator.generateKeyPair();
        SecretKey ephemeralSecretKey = generator.computeSharedKey(ephemeralKeyPair.getPrivate(), masterPublicKey);
        SecretKey sessionRelatedSecretKey = generator.deriveSecretKeyHmacLegacy(ephemeralSecretKey, sessionIndex);
        byte[] sessionRelatedSecretKeyBytes = this.keyConvertor.convertSharedSecretKeyToBytes(sessionRelatedSecretKey);
        byte[] ephemeralPublicKeyBytes = this.keyConvertor.convertPublicKeyToBytes(ephemeralKeyPair.getPublic());
        this.encryptor = new NonPersonalizedEncryptor(appKey, sessionRelatedSecretKeyBytes, sessionIndex, ephemeralPublicKeyBytes);
    }

    public NonPersonalizedEncryptedMessage encrypt(byte[] data) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        return this.encryptor.encrypt(data);
    }

    public byte[] decrypt(NonPersonalizedEncryptedMessage message) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        return this.encryptor.decrypt(message);
    }
}

