/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.client.activation;

import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.model.ActivationStatusBlobInfo;
import io.getlime.security.powerauth.crypto.lib.model.ActivationVersion;
import io.getlime.security.powerauth.crypto.lib.model.exception.CryptoProviderException;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.crypto.lib.util.AESEncryptionUtils;
import io.getlime.security.powerauth.crypto.lib.util.ECPublicKeyFingerprint;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import io.getlime.security.powerauth.crypto.lib.util.HashBasedCounterUtils;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.crypto.lib.util.KeyDerivationUtils;
import io.getlime.security.powerauth.crypto.lib.util.SignatureUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKey;

public class PowerAuthClientActivation {
    private final SignatureUtils signatureUtils = new SignatureUtils();
    private final KeyGenerator keyGenerator = new KeyGenerator();
    private final KeyConvertor keyConvertor = new KeyConvertor();

    public boolean verifyActivationCodeSignature(String activationCode, byte[] signature, PublicKey masterPublicKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        byte[] bytes = activationCode.getBytes(StandardCharsets.UTF_8);
        return this.signatureUtils.validateECDSASignature(bytes, signature, masterPublicKey);
    }

    public KeyPair generateDeviceKeyPair() throws CryptoProviderException {
        return this.keyGenerator.generateKeyPair();
    }

    public byte[] generateActivationNonce() throws CryptoProviderException {
        return this.keyGenerator.generateRandomBytes(16);
    }

    public byte[] computeApplicationSignature(String activationIdShort, byte[] activationNonce, byte[] encryptedDevicePublicKey, byte[] applicationKey, byte[] applicationSecret) throws GenericCryptoException, CryptoProviderException {
        String signatureBaseString = activationIdShort + "&" + BaseEncoding.base64().encode(activationNonce) + "&" + BaseEncoding.base64().encode(encryptedDevicePublicKey) + "&" + BaseEncoding.base64().encode(applicationKey);
        return new HMACHashUtilities().hash(applicationSecret, signatureBaseString.getBytes(StandardCharsets.UTF_8));
    }

    public byte[] encryptDevicePublicKey(PublicKey devicePublicKey, PrivateKey clientEphemeralPrivateKey, PublicKey masterPublicKey, String activationOTP, String activationIdShort, byte[] activationNonce) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        byte[] activationIdShortBytes = activationIdShort.getBytes(StandardCharsets.UTF_8);
        SecretKey otpBasedSymmetricKey = this.keyGenerator.deriveSecretKeyFromPassword(activationOTP, activationIdShortBytes);
        byte[] devicePubKeyBytes = this.keyConvertor.convertPublicKeyToBytes(devicePublicKey);
        SecretKey ephemeralKey = this.keyGenerator.computeSharedKey(clientEphemeralPrivateKey, masterPublicKey);
        AESEncryptionUtils aes = new AESEncryptionUtils();
        byte[] tmpData = aes.encrypt(devicePubKeyBytes, activationNonce, otpBasedSymmetricKey);
        return aes.encrypt(tmpData, activationNonce, ephemeralKey);
    }

    public boolean verifyServerDataSignature(String activationId, byte[] C_serverPublicKey, byte[] signature, PublicKey masterPublicKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        byte[] activationIdBytes = activationId.getBytes(StandardCharsets.UTF_8);
        String activationIdBytesBase64 = BaseEncoding.base64().encode(activationIdBytes);
        String C_serverPublicKeyBase64 = BaseEncoding.base64().encode(C_serverPublicKey);
        byte[] result = (activationIdBytesBase64 + "&" + C_serverPublicKeyBase64).getBytes(StandardCharsets.UTF_8);
        return this.signatureUtils.validateECDSASignature(result, signature, masterPublicKey);
    }

    public PublicKey decryptServerPublicKey(byte[] C_serverPublicKey, PrivateKey devicePrivateKey, PublicKey ephemeralPublicKey, String activationOTP, String activationIdShort, byte[] activationNonce) throws InvalidKeyException, InvalidKeySpecException, GenericCryptoException, CryptoProviderException {
        SecretKey ephemeralSymmetricKey = this.keyGenerator.computeSharedKey(devicePrivateKey, ephemeralPublicKey);
        byte[] activationIdShortBytes = activationIdShort.getBytes(StandardCharsets.UTF_8);
        SecretKey otpBasedSymmetricKey = this.keyGenerator.deriveSecretKeyFromPassword(activationOTP, activationIdShortBytes);
        AESEncryptionUtils aes = new AESEncryptionUtils();
        byte[] decryptedTMP = aes.decrypt(C_serverPublicKey, activationNonce, ephemeralSymmetricKey);
        byte[] decryptedServerPublicKeyBytes = aes.decrypt(decryptedTMP, activationNonce, otpBasedSymmetricKey);
        return this.keyConvertor.convertBytesToPublicKey(decryptedServerPublicKeyBytes);
    }

    public String computeActivationFingerprint(PublicKey devicePublicKey) throws GenericCryptoException, CryptoProviderException {
        return this.computeActivationFingerprint(devicePublicKey, null, null, ActivationVersion.VERSION_2);
    }

    public String computeActivationFingerprint(PublicKey devicePublicKey, PublicKey serverPublicKey, String activationId) throws GenericCryptoException, CryptoProviderException {
        return this.computeActivationFingerprint(devicePublicKey, serverPublicKey, activationId, ActivationVersion.VERSION_3);
    }

    public String computeActivationFingerprint(PublicKey devicePublicKey, PublicKey serverPublicKey, String activationId, ActivationVersion activationVersion) throws GenericCryptoException, CryptoProviderException {
        return ECPublicKeyFingerprint.compute((ECPublicKey)devicePublicKey, (ECPublicKey)serverPublicKey, activationId, activationVersion);
    }

    public ActivationStatusBlobInfo getStatusFromEncryptedBlob(byte[] cStatusBlob, byte[] challenge, byte[] nonce, SecretKey transportKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        if (cStatusBlob.length != 32) {
            throw new GenericCryptoException("Invalid status blob size");
        }
        AESEncryptionUtils aes = new AESEncryptionUtils();
        byte[] iv = new KeyDerivationUtils().deriveIvForStatusBlobEncryption(challenge, nonce, transportKey);
        byte[] statusBlob = aes.decrypt(cStatusBlob, iv, transportKey, "AES/CBC/NoPadding");
        ActivationStatusBlobInfo statusInfo = new ActivationStatusBlobInfo();
        ByteBuffer buffer = ByteBuffer.wrap(statusBlob);
        int prefix = buffer.getInt(0);
        statusInfo.setValid(prefix == -557785391);
        statusInfo.setActivationStatus(buffer.get(4));
        statusInfo.setCurrentVersion(buffer.get(5));
        statusInfo.setUpgradeVersion(buffer.get(6));
        statusInfo.setCtrByte(buffer.get(12));
        statusInfo.setFailedAttempts(buffer.get(13));
        statusInfo.setMaxFailedAttempts(buffer.get(14));
        statusInfo.setCtrLookAhead(buffer.get(15));
        byte[] ctrData = Arrays.copyOfRange(statusBlob, 16, 32);
        statusInfo.setCtrDataHash(ctrData);
        return statusInfo;
    }

    public boolean verifyHashForHashBasedCounter(byte[] receivedCtrDataHash, byte[] expectedCtrData, SecretKey transportKey) throws CryptoProviderException, InvalidKeyException, GenericCryptoException {
        return new HashBasedCounterUtils().verifyHashForHashBasedCounter(receivedCtrDataHash, expectedCtrData, transportKey);
    }
}

