/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.server.util;

import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import io.getlime.security.powerauth.provider.exception.CryptoProviderException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataDigest {
    private static final Logger logger = LoggerFactory.getLogger(DataDigest.class);
    private static final int AUTHORIZATION_CODE_LENGTH = 8;
    private final HMACHashUtilities hmac = new HMACHashUtilities();

    public Result generateDigest(List<String> items) {
        if (items.size() == 0) {
            return null;
        }
        byte[] operationData = String.join((CharSequence)"&", items).getBytes(StandardCharsets.UTF_8);
        byte[] randomKey = new KeyGenerator().generateRandomBytes(16);
        try {
            byte[] otpHash = this.hmac.hash(randomKey, operationData);
            BigInteger otp = new BigInteger(otpHash).mod(BigInteger.TEN.pow(8));
            String digitFormat = "%" + String.format("%02d", 8) + "d";
            String digest = String.format(digitFormat, otp);
            return new Result(digest, randomKey);
        }
        catch (GenericCryptoException | CryptoProviderException ex) {
            logger.warn(ex.getMessage(), ex);
            return null;
        }
    }

    public static class Result {
        private final String digest;
        private final byte[] salt;

        Result(String digest, byte[] salt) {
            this.digest = digest;
            this.salt = salt;
        }

        public String getDigest() {
            return this.digest;
        }

        public byte[] getSalt() {
            return this.salt;
        }
    }
}

