/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.util;

import com.google.common.primitives.Bytes;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import io.getlime.security.powerauth.provider.exception.CryptoProviderException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;

public class TokenUtils {
    private final KeyGenerator keyGenerator = new KeyGenerator();
    private final HMACHashUtilities hmac = new HMACHashUtilities();

    public String generateTokenId() {
        return UUID.randomUUID().toString();
    }

    public byte[] generateTokenSecret() {
        return this.keyGenerator.generateRandomBytes(16);
    }

    public byte[] generateTokenNonce() {
        return this.keyGenerator.generateRandomBytes(16);
    }

    public byte[] generateTokenTimestamp() {
        return String.valueOf(System.currentTimeMillis()).getBytes(StandardCharsets.UTF_8);
    }

    public byte[] convertTokenTimestamp(long timestamp) {
        return String.valueOf(timestamp).getBytes(StandardCharsets.UTF_8);
    }

    public byte[] computeTokenDigest(byte[] nonce, byte[] timestamp, byte[] tokenSecret) throws GenericCryptoException, CryptoProviderException {
        byte[] amp = "&".getBytes(StandardCharsets.UTF_8);
        byte[] data = Bytes.concat((byte[][])new byte[][]{nonce, amp, timestamp});
        return this.hmac.hash(tokenSecret, data);
    }

    public boolean validateTokenDigest(byte[] nonce, byte[] timestamp, byte[] tokenSecret, byte[] tokenDigest) throws GenericCryptoException, CryptoProviderException {
        return Arrays.equals(this.computeTokenDigest(nonce, timestamp, tokenSecret), tokenDigest);
    }
}

