/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.util;

import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.model.Argon2Hash;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;

public class PasswordHash {
    private static final int ALGORITHM_ID = 1;
    private static final int VERSION = 19;
    private static final int ITERATIONS = 3;
    private static final int MEMORY_POW_2 = 15;
    private static final int PARALLELISM = 16;
    private static final Map<Integer, String> ALGORITHM_NAME_MAP = new LinkedHashMap<Integer, String>();
    private static KeyGenerator keyGenerator;

    public static String hash(byte[] password) {
        byte[] salt = keyGenerator.generateRandomBytes(8);
        Argon2Parameters.Builder builder = new Argon2Parameters.Builder(1).withVersion(19).withIterations(3).withMemoryPowOfTwo(15).withParallelism(16).withSalt(salt);
        Argon2Parameters parameters = builder.build();
        Argon2Hash argon2Hash = PasswordHash.hash(password, parameters);
        return argon2Hash.toString();
    }

    public static boolean verify(byte[] password, String argon2Hash) throws IOException {
        Argon2Hash input = Argon2Hash.parse(argon2Hash);
        int algorithmId = 1;
        for (Map.Entry<Integer, String> entry : ALGORITHM_NAME_MAP.entrySet()) {
            if (!entry.getValue().equals(input.getAlgorithm())) continue;
            algorithmId = entry.getKey();
            break;
        }
        Argon2Parameters.Builder builder = new Argon2Parameters.Builder(algorithmId).withVersion(input.getVersion().intValue()).withIterations(input.getIterations().intValue()).withMemoryAsKB(input.getMemory().intValue()).withParallelism(input.getParallelism().intValue()).withSalt(input.getSalt());
        Argon2Parameters parameters = builder.build();
        Argon2Hash expectedHash = PasswordHash.hash(password, parameters);
        return input.hashEquals(expectedHash);
    }

    private static Argon2Hash hash(byte[] password, Argon2Parameters parameters) {
        Argon2BytesGenerator gen = new Argon2BytesGenerator();
        gen.init(parameters);
        byte[] digest = new byte[32];
        gen.generateBytes(password, digest);
        String algorithmName = ALGORITHM_NAME_MAP.get(parameters.getType());
        Argon2Hash result = new Argon2Hash(algorithmName);
        result.setVersion(parameters.getVersion());
        result.setIterations(parameters.getIterations());
        result.setParallelism(parameters.getLanes());
        result.setMemory(parameters.getMemory());
        result.setSalt(parameters.getSalt());
        result.setDigest(digest);
        return result;
    }

    static {
        ALGORITHM_NAME_MAP.put(1, "argon2i");
        ALGORITHM_NAME_MAP.put(0, "argon2d");
        ALGORITHM_NAME_MAP.put(2, "argon2id");
        keyGenerator = new KeyGenerator();
    }
}

