/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.util;

import com.google.common.primitives.Bytes;
import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.provider.exception.CryptoProviderException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import javax.crypto.SecretKey;

public class KeyDerivationUtils {
    private final KeyGenerator keyGenerator = new KeyGenerator();
    private static final long STATUS_BLOB_TRANSPORT_IV_INDEX = 3000L;
    private static final int STATUS_BLOB_IV_LENGTH = 16;
    private static final int STATUS_BLOB_CHALLENGE_LENGTH = 16;
    private static final int STATUS_BLOB_NONCE_LENGTH = 16;

    public byte[] deriveIvForStatusBlobEncryption(byte[] challenge, byte[] nonce, SecretKey transportKey) throws GenericCryptoException, CryptoProviderException, InvalidKeyException {
        if (challenge == null && nonce == null) {
            return new byte[16];
        }
        if (challenge == null || challenge.length != 16) {
            throw new GenericCryptoException("Invalid challenge provided");
        }
        if (nonce == null || nonce.length != 16) {
            throw new GenericCryptoException("Invalid nonce provided");
        }
        byte[] derivationIndex = ByteBuffer.allocate(16).putLong(0L).putLong(3000L).array();
        SecretKey transportIv = this.keyGenerator.deriveSecretKey(transportKey, derivationIndex);
        byte[] ivData = Bytes.concat((byte[][])new byte[][]{challenge, nonce});
        SecretKey ivKey = this.keyGenerator.deriveSecretKeyHmac(transportIv, ivData);
        return PowerAuthConfiguration.INSTANCE.getKeyConvertor().convertSharedSecretKeyToBytes(ivKey);
    }
}

