/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hash {
    private static final Logger logger = LoggerFactory.getLogger(Hash.class);

    private static byte[] hash(byte[] originalBytes) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        return md.digest(originalBytes);
    }

    public static byte[] sha256(byte[] originalBytes) {
        try {
            return Hash.hash(originalBytes);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static byte[] sha256(String string) {
        return Hash.sha256(string, StandardCharsets.UTF_8);
    }

    public static byte[] sha256(String string, Charset charset) {
        byte[] originalBytes = string.getBytes(charset);
        return Hash.sha256(originalBytes);
    }
}

