/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.util;

import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.provider.exception.CryptoProviderException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMACHashUtilities {
    private static final Logger logger = LoggerFactory.getLogger(HMACHashUtilities.class);

    public byte[] hash(byte[] key, byte[] data) throws GenericCryptoException, CryptoProviderException {
        try {
            Mac hmacSha256 = Mac.getInstance("HmacSHA256", PowerAuthConfiguration.INSTANCE.getKeyConvertor().getProviderName());
            SecretKeySpec hmacKey = new SecretKeySpec(key, "HmacSHA256");
            hmacSha256.init(hmacKey);
            return hmacSha256.doFinal(data);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new CryptoProviderException(ex.getMessage(), (Throwable)ex);
        }
        catch (InvalidKeyException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new GenericCryptoException(ex.getMessage(), ex);
        }
    }

    public byte[] hash(SecretKey hmacKey, byte[] data) throws GenericCryptoException, CryptoProviderException {
        try {
            Mac hmacSha256 = Mac.getInstance("HmacSHA256", PowerAuthConfiguration.INSTANCE.getKeyConvertor().getProviderName());
            hmacSha256.init(hmacKey);
            return hmacSha256.doFinal(data);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new CryptoProviderException(ex.getMessage(), (Throwable)ex);
        }
        catch (InvalidKeyException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new GenericCryptoException(ex.getMessage(), ex);
        }
    }
}

