/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.util;

import io.getlime.security.powerauth.crypto.lib.model.ActivationVersion;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.provider.exception.CryptoProviderException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECPublicKeyFingerprint {
    private static final Logger logger = LoggerFactory.getLogger(ECPublicKeyFingerprint.class);

    public static String compute(ECPublicKey devicePublicKey, ECPublicKey serverPublicKey, String activationId, ActivationVersion activationVersion) throws GenericCryptoException, CryptoProviderException {
        if (devicePublicKey == null) {
            throw new GenericCryptoException("Device public key is invalid");
        }
        try {
            byte[] fingerprintData;
            switch (activationVersion) {
                case VERSION_2: {
                    fingerprintData = ECPublicKeyFingerprint.toByteArray(devicePublicKey);
                    break;
                }
                case VERSION_3: {
                    if (serverPublicKey == null) {
                        throw new GenericCryptoException("Server public key is invalid");
                    }
                    if (activationId == null) {
                        throw new GenericCryptoException("Activation ID is invalid");
                    }
                    byte[] devicePublicKeyBytes = ECPublicKeyFingerprint.toByteArray(devicePublicKey);
                    byte[] activationIdBytes = activationId.getBytes(StandardCharsets.UTF_8);
                    byte[] serverPublicKeyBytes = ECPublicKeyFingerprint.toByteArray(serverPublicKey);
                    ByteBuffer dataBuffer = ByteBuffer.allocate(devicePublicKeyBytes.length + activationIdBytes.length + serverPublicKeyBytes.length);
                    dataBuffer.put(devicePublicKeyBytes);
                    dataBuffer.put(activationIdBytes);
                    dataBuffer.put(serverPublicKeyBytes);
                    fingerprintData = dataBuffer.array();
                    break;
                }
                default: {
                    throw new GenericCryptoException("Unsupported activation version: " + (Object)((Object)activationVersion));
                }
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(fingerprintData);
            if (hash.length < 4) {
                throw new GenericCryptoException("Invalid digest");
            }
            int index = hash.length - 4;
            int number = (ByteBuffer.wrap(hash).getInt(index) & Integer.MAX_VALUE) % (int)Math.pow(10.0, 8.0);
            return String.format("%08d", number);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new CryptoProviderException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static byte[] toByteArray(ECPublicKey publicKey) {
        byte[] publicKeyBytes = publicKey.getW().getAffineX().toByteArray();
        if (publicKeyBytes[0] == 0) {
            publicKeyBytes = Arrays.copyOfRange(publicKeyBytes, 1, publicKeyBytes.length);
        }
        return publicKeyBytes;
    }
}

