/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.model;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Argon2Hash {
    private String algorithm;
    private Integer version;
    private Map<String, Integer> parameters = new HashMap<String, Integer>();
    private byte[] salt;
    private byte[] digest;

    private Argon2Hash() {
    }

    public Argon2Hash(String algorithm) {
        this.algorithm = algorithm;
    }

    public static Argon2Hash parse(String input) throws IOException {
        if (input == null) {
            throw new IOException("Missing input parameter");
        }
        String[] parts = input.split("\\$");
        Argon2Hash hash = new Argon2Hash();
        if (input.matches("\\$argon2(?:i|d|id)]?\\$m=[0-9]+,t=[0-9]+,p=[0-9]+\\$[A-Za-z0-9+/]+\\$[A-Za-z0-9+/]+")) {
            hash.setAlgorithm(parts[1]);
            hash.setParameters(Argon2Hash.extractParameters(parts[2]));
            hash.setSalt(BaseEncoding.base64().decode((CharSequence)parts[3]));
            hash.setDigest(BaseEncoding.base64().decode((CharSequence)parts[4]));
            return hash;
        }
        if (input.matches("\\$argon2(?:i|d|id)?\\$v=[0-9]+\\$m=[0-9]+,t=[0-9]+,p=[0-9]+\\$[A-Za-z0-9+/]+\\$[A-Za-z0-9+/]+")) {
            hash.setAlgorithm(parts[1]);
            Integer version = Argon2Hash.extractVersion(parts[2]);
            if (version != null) {
                hash.setVersion(version);
            }
            hash.setParameters(Argon2Hash.extractParameters(parts[3]));
            hash.setSalt(BaseEncoding.base64().decode((CharSequence)parts[4]));
            hash.setDigest(BaseEncoding.base64().decode((CharSequence)parts[5]));
            return hash;
        }
        throw new IOException("Invalid Argon2 hash syntax");
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        if (version == 16) {
            return;
        }
        this.version = version;
    }

    public Map<String, Integer> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Integer> parameters) {
        this.parameters = parameters;
    }

    public Integer getIterations() {
        return this.parameters.get("t");
    }

    public void setIterations(Integer iterations) {
        this.parameters.put("t", iterations);
    }

    public Integer getMemory() {
        return this.parameters.get("m");
    }

    public void setMemory(Integer memory) {
        this.parameters.put("m", memory);
    }

    public Integer getParallelism() {
        return this.parameters.get("p");
    }

    public void setParallelism(Integer parallelism) {
        this.parameters.put("p", parallelism);
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public void setSalt(byte[] salt) {
        this.salt = salt;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public void setDigest(byte[] digest) {
        this.digest = digest;
    }

    public boolean hashEquals(Argon2Hash other) {
        if (this.digest == null || other.digest == null) {
            return false;
        }
        return Arrays.equals(this.digest, other.digest);
    }

    private static Integer extractVersion(String versionDef) {
        String versionStr;
        if (versionDef != null && versionDef.startsWith("v=") && versionDef.length() > 2 && (versionStr = versionDef.substring(2)).matches("[0-9]+")) {
            return Integer.parseInt(versionStr);
        }
        return null;
    }

    private static Map<String, Integer> extractParameters(String paramDef) {
        String[] parts;
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        if (paramDef == null || !paramDef.contains(",")) {
            return parameters;
        }
        for (String part : parts = paramDef.split(",")) {
            if (!part.contains("=")) continue;
            String[] keyValue = part.split("=");
            String key = keyValue[0];
            if (!keyValue[1].matches("[0-9]+")) continue;
            Integer value = Integer.parseInt(keyValue[1]);
            parameters.put(key, value);
        }
        return parameters;
    }

    private String versionToString() {
        if (this.version == null) {
            return "";
        }
        return "v=" + this.version;
    }

    private String parametersToString() {
        Integer parallelism;
        Integer iterations;
        if (this.parameters == null || this.parameters.isEmpty()) {
            return "";
        }
        ArrayList<String> parts = new ArrayList<String>();
        Integer memory = this.parameters.get("m");
        if (memory != null) {
            parts.add("m=" + memory);
        }
        if ((iterations = this.parameters.get("t")) != null) {
            parts.add("t=" + iterations);
        }
        if ((parallelism = this.parameters.get("p")) != null) {
            parts.add("p=" + parallelism);
        }
        return String.join((CharSequence)",", parts);
    }

    public String toString() {
        return "$" + this.algorithm + (this.version != null ? "$" + this.versionToString() : "") + "$" + this.parametersToString() + "$" + BaseEncoding.base64().omitPadding().encode(this.salt) + "$" + BaseEncoding.base64().omitPadding().encode(this.digest);
    }
}

