/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.generator;

import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.crypto.lib.util.AESEncryptionUtils;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import io.getlime.security.powerauth.provider.CryptoProviderUtil;
import io.getlime.security.powerauth.provider.exception.CryptoProviderException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyGenerator {
    private static final Logger logger = LoggerFactory.getLogger(KeyGenerator.class);
    private final SecureRandom random = new SecureRandom();

    public KeyPair generateKeyPair() throws CryptoProviderException {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("ECDH", PowerAuthConfiguration.INSTANCE.getKeyConvertor().getProviderName());
            kpg.initialize(new ECGenParameterSpec("secp256r1"));
            return kpg.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new CryptoProviderException(ex.getMessage(), (Throwable)ex);
        }
    }

    public SecretKey computeSharedKey(PrivateKey privateKey, PublicKey publicKey, boolean keep32b) throws InvalidKeyException, CryptoProviderException {
        try {
            KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH", PowerAuthConfiguration.INSTANCE.getKeyConvertor().getProviderName());
            keyAgreement.init(privateKey);
            keyAgreement.doPhase(publicKey, true);
            byte[] sharedSecret = keyAgreement.generateSecret();
            byte[] resultSecret = keep32b ? sharedSecret : this.convert32Bto16B(sharedSecret);
            return PowerAuthConfiguration.INSTANCE.getKeyConvertor().convertBytesToSharedSecretKey(resultSecret);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new CryptoProviderException(ex.getMessage(), (Throwable)ex);
        }
    }

    public SecretKey computeSharedKey(PrivateKey privateKey, PublicKey publicKey) throws InvalidKeyException, CryptoProviderException {
        return this.computeSharedKey(privateKey, publicKey, false);
    }

    public byte[] convert32Bto16B(byte[] original) throws IllegalArgumentException {
        if (original.length != 32) {
            throw new IllegalArgumentException("Invalid byte array size, expected: 32, provided: " + original.length);
        }
        byte[] resultSecret = new byte[16];
        for (int i = 0; i < 16; ++i) {
            resultSecret[i] = (byte)(original[i] ^ original[i + 16]);
        }
        return resultSecret;
    }

    public byte[] generateRandomBytes(int len) {
        byte[] randomBytes = new byte[len];
        this.random.nextBytes(randomBytes);
        return randomBytes;
    }

    public SecretKey generateRandomSecretKey() {
        return PowerAuthConfiguration.INSTANCE.getKeyConvertor().convertBytesToSharedSecretKey(this.generateRandomBytes(16));
    }

    public SecretKey deriveSecretKey(SecretKey secret, byte[] index) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        AESEncryptionUtils aes = new AESEncryptionUtils();
        byte[] iv = new byte[16];
        byte[] encryptedBytes = aes.encrypt(index, iv, secret);
        return PowerAuthConfiguration.INSTANCE.getKeyConvertor().convertBytesToSharedSecretKey(Arrays.copyOf(encryptedBytes, 16));
    }

    @Deprecated
    public SecretKey deriveSecretKeyHmacLegacy(SecretKey secret, byte[] index) throws GenericCryptoException, CryptoProviderException {
        CryptoProviderUtil keyConvertor = PowerAuthConfiguration.INSTANCE.getKeyConvertor();
        byte[] secretKeyBytes = keyConvertor.convertSharedSecretKeyToBytes(secret);
        HMACHashUtilities hmac = new HMACHashUtilities();
        byte[] derivedKey32 = hmac.hash(index, secretKeyBytes);
        byte[] newKeyBytes = this.convert32Bto16B(derivedKey32);
        return keyConvertor.convertBytesToSharedSecretKey(newKeyBytes);
    }

    public SecretKey deriveSecretKeyHmac(SecretKey secret, byte[] index) throws GenericCryptoException, CryptoProviderException {
        CryptoProviderUtil keyConvertor = PowerAuthConfiguration.INSTANCE.getKeyConvertor();
        byte[] secretKeyBytes = keyConvertor.convertSharedSecretKeyToBytes(secret);
        HMACHashUtilities hmac = new HMACHashUtilities();
        byte[] derivedKey32 = hmac.hash(secretKeyBytes, index);
        byte[] newKeyBytes = this.convert32Bto16B(derivedKey32);
        return keyConvertor.convertBytesToSharedSecretKey(newKeyBytes);
    }

    public SecretKey deriveSecretKeyFromPassword(String password, byte[] salt) throws CryptoProviderException {
        return this.deriveSecretKeyFromPassword(password, salt, 10000);
    }

    public SecretKey deriveSecretKeyFromPassword(String password, byte[] salt, int iterations) throws CryptoProviderException {
        try {
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, iterations, 128);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1", PowerAuthConfiguration.INSTANCE.getKeyConvertor().getProviderName());
            byte[] keyBytes = skf.generateSecret(spec).getEncoded();
            return new SecretKeySpec(keyBytes, "AES");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new CryptoProviderException(ex.getMessage(), (Throwable)ex);
        }
    }
}

