/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.generator;

import io.getlime.security.powerauth.crypto.lib.api.Counter;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.Hash;

public class HashBasedCounter
implements Counter {
    private static final int HASH_COUNTER_RANDOM_BYTES_LENGTH = 16;
    private final KeyGenerator keyGenerator = new KeyGenerator();

    @Override
    public byte[] init() {
        return this.keyGenerator.generateRandomBytes(16);
    }

    @Override
    public byte[] next(byte[] ctrData) {
        byte[] nextCtrData = Hash.sha256(ctrData);
        if (nextCtrData != null) {
            return this.keyGenerator.convert32Bto16B(nextCtrData);
        }
        return null;
    }
}

