/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.encryptor.ecies;

import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesDecryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesEnvelopeKey;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesScope;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesSharedInfo1;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import io.getlime.security.powerauth.crypto.lib.util.Hash;
import io.getlime.security.powerauth.provider.exception.CryptoProviderException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;

public class EciesFactory {
    private final HMACHashUtilities hmacHashUtilities = new HMACHashUtilities();

    public EciesEncryptor getEciesEncryptorForApplication(ECPublicKey publicKey, byte[] applicationSecret, EciesSharedInfo1 sharedInfo1) throws GenericCryptoException, CryptoProviderException {
        byte[] sharedInfo1Value = sharedInfo1 == null ? EciesSharedInfo1.APPLICATION_SCOPE_GENERIC.value() : sharedInfo1.value();
        return this.getEciesEncryptor(EciesScope.APPLICATION_SCOPE, publicKey, applicationSecret, null, sharedInfo1Value);
    }

    public EciesEncryptor getEciesEncryptorForActivation(ECPublicKey publicKey, byte[] applicationSecret, byte[] transportKey, EciesSharedInfo1 sharedInfo1) throws GenericCryptoException, CryptoProviderException {
        byte[] sharedInfo1Value = sharedInfo1 == null ? EciesSharedInfo1.ACTIVATION_SCOPE_GENERIC.value() : sharedInfo1.value();
        return this.getEciesEncryptor(EciesScope.ACTIVATION_SCOPE, publicKey, applicationSecret, transportKey, sharedInfo1Value);
    }

    public EciesEncryptor getEciesEncryptor(EciesEnvelopeKey envelopeKey, byte[] sharedInfo2) {
        return new EciesEncryptor(envelopeKey, sharedInfo2);
    }

    private EciesEncryptor getEciesEncryptor(EciesScope eciesScope, ECPublicKey publicKey, byte[] applicationSecret, byte[] transportKey, byte[] sharedInfo1) throws GenericCryptoException, CryptoProviderException {
        switch (eciesScope) {
            case APPLICATION_SCOPE: {
                byte[] sharedInfo2 = Hash.sha256(applicationSecret);
                return new EciesEncryptor(publicKey, sharedInfo1, sharedInfo2);
            }
            case ACTIVATION_SCOPE: {
                byte[] sharedInfo2 = this.hmacHashUtilities.hash(transportKey, applicationSecret);
                return new EciesEncryptor(publicKey, sharedInfo1, sharedInfo2);
            }
        }
        throw new GenericCryptoException("Unsupported ECIES scope: " + (Object)((Object)eciesScope));
    }

    public EciesDecryptor getEciesDecryptorForApplication(ECPrivateKey privateKey, byte[] applicationSecret, EciesSharedInfo1 sharedInfo1) throws GenericCryptoException, CryptoProviderException {
        byte[] sharedInfo1Value = sharedInfo1 == null ? EciesSharedInfo1.APPLICATION_SCOPE_GENERIC.value() : sharedInfo1.value();
        return this.getEciesDecryptor(EciesScope.APPLICATION_SCOPE, privateKey, applicationSecret, null, sharedInfo1Value);
    }

    public EciesDecryptor getEciesDecryptorForActivation(ECPrivateKey privateKey, byte[] applicationSecret, byte[] transportKey, EciesSharedInfo1 sharedInfo1) throws GenericCryptoException, CryptoProviderException {
        byte[] sharedInfo1Value = sharedInfo1 == null ? EciesSharedInfo1.ACTIVATION_SCOPE_GENERIC.value() : sharedInfo1.value();
        return this.getEciesDecryptor(EciesScope.ACTIVATION_SCOPE, privateKey, applicationSecret, transportKey, sharedInfo1Value);
    }

    public EciesDecryptor getEciesDecryptor(EciesEnvelopeKey envelopeKey, byte[] sharedInfo2) {
        return new EciesDecryptor(envelopeKey, sharedInfo2);
    }

    private EciesDecryptor getEciesDecryptor(EciesScope eciesScope, ECPrivateKey privateKey, byte[] applicationSecret, byte[] transportKey, byte[] sharedInfo1) throws GenericCryptoException, CryptoProviderException {
        switch (eciesScope) {
            case APPLICATION_SCOPE: {
                byte[] sharedInfo2 = Hash.sha256(applicationSecret);
                return new EciesDecryptor(privateKey, sharedInfo1, sharedInfo2);
            }
            case ACTIVATION_SCOPE: {
                byte[] sharedInfo2 = this.hmacHashUtilities.hash(transportKey, applicationSecret);
                return new EciesDecryptor(privateKey, sharedInfo1, sharedInfo2);
            }
        }
        throw new GenericCryptoException("Unsupported ECIES scope: " + (Object)((Object)eciesScope));
    }
}

