/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.encryptor;

import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.NonPersonalizedEncryptedMessage;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.crypto.lib.util.AESEncryptionUtils;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import io.getlime.security.powerauth.provider.CryptoProviderUtil;
import io.getlime.security.powerauth.provider.exception.CryptoProviderException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import javax.crypto.SecretKey;

public class NonPersonalizedEncryptor {
    private static final int MAX_ATTEMPT_COUNT = 1000;
    private byte[] applicationKey;
    private byte[] sessionIndex;
    private byte[] sessionRelatedSecretKey;
    private byte[] ephemeralPublicKey;
    private final AESEncryptionUtils aes = new AESEncryptionUtils();
    private final KeyGenerator generator = new KeyGenerator();
    private final HMACHashUtilities hmac = new HMACHashUtilities();
    private final CryptoProviderUtil keyConversion = PowerAuthConfiguration.INSTANCE.getKeyConvertor();

    public NonPersonalizedEncryptor(byte[] applicationKey, byte[] sessionRelatedSecretKey, byte[] sessionIndex, byte[] ephemeralPublicKeyString) {
        this.applicationKey = applicationKey;
        this.sessionIndex = sessionIndex;
        this.sessionRelatedSecretKey = sessionRelatedSecretKey;
        this.ephemeralPublicKey = ephemeralPublicKeyString;
    }

    public NonPersonalizedEncryptedMessage encrypt(byte[] originalData) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        byte[] adHocIndex = this.generator.generateRandomBytes(16);
        byte[] macIndex = this.generator.generateRandomBytes(16);
        int attemptCount = 0;
        while (Arrays.equals(adHocIndex, macIndex)) {
            macIndex = this.generator.generateRandomBytes(16);
            if (attemptCount < 1000) {
                ++attemptCount;
                continue;
            }
            throw new GenericCryptoException("Random byte array generation failed");
        }
        byte[] nonce = this.generator.generateRandomBytes(16);
        SecretKey sessionKey = this.keyConversion.convertBytesToSharedSecretKey(this.sessionRelatedSecretKey);
        SecretKey encryptionKey = this.generator.deriveSecretKeyHmacLegacy(sessionKey, adHocIndex);
        SecretKey macKey = this.generator.deriveSecretKeyHmacLegacy(sessionKey, macIndex);
        byte[] encryptedData = this.aes.encrypt(originalData, nonce, encryptionKey);
        byte[] mac = this.hmac.hash(macKey, encryptedData);
        NonPersonalizedEncryptedMessage message = new NonPersonalizedEncryptedMessage();
        message.setApplicationKey(this.applicationKey);
        message.setEphemeralPublicKey(this.ephemeralPublicKey);
        message.setSessionIndex(this.sessionIndex);
        message.setAdHocIndex(adHocIndex);
        message.setMacIndex(macIndex);
        message.setNonce(nonce);
        message.setEncryptedData(encryptedData);
        message.setMac(mac);
        return message;
    }

    public byte[] decrypt(NonPersonalizedEncryptedMessage message) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        byte[] adHocIndex = message.getAdHocIndex();
        byte[] macIndex = message.getMacIndex();
        byte[] nonce = message.getNonce();
        if (adHocIndex == null || macIndex == null || nonce == null) {
            throw new GenericCryptoException("Invalid message");
        }
        if (adHocIndex.length != 16 || macIndex.length != 16) {
            throw new GenericCryptoException("Invalid index");
        }
        if (nonce.length != 16) {
            throw new GenericCryptoException("Invalid nonce");
        }
        if (Arrays.equals(adHocIndex, macIndex)) {
            throw new GenericCryptoException("Invalid index");
        }
        SecretKey sessionKey = this.keyConversion.convertBytesToSharedSecretKey(this.sessionRelatedSecretKey);
        SecretKey encryptionKey = this.generator.deriveSecretKeyHmacLegacy(sessionKey, adHocIndex);
        SecretKey macKey = this.generator.deriveSecretKeyHmacLegacy(sessionKey, macIndex);
        byte[] encryptedData = message.getEncryptedData();
        byte[] macExpected = this.hmac.hash(macKey, encryptedData);
        byte[] mac = message.getMac();
        if (!Arrays.equals(mac, macExpected)) {
            throw new GenericCryptoException("Invalid mac");
        }
        return this.aes.decrypt(encryptedData, nonce, encryptionKey);
    }

    public byte[] getApplicationKey() {
        return this.applicationKey;
    }

    public void setApplicationKey(byte[] applicationKey) {
        this.applicationKey = applicationKey;
    }

    public byte[] getSessionIndex() {
        return this.sessionIndex;
    }

    public void setSessionIndex(byte[] sessionIndex) {
        this.sessionIndex = sessionIndex;
    }

    public byte[] getEphemeralPublicKey() {
        return this.ephemeralPublicKey;
    }

    public void setEphemeralPublicKey(byte[] ephemeralPublicKey) {
        this.ephemeralPublicKey = ephemeralPublicKey;
    }

    public byte[] getSessionRelatedSecretKey() {
        return this.sessionRelatedSecretKey;
    }

    public void setSessionRelatedSecretKey(byte[] sessionRelatedSecretKey) {
        this.sessionRelatedSecretKey = sessionRelatedSecretKey;
    }
}

