/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.client.keyfactory;

import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthDerivedKey;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.provider.exception.CryptoProviderException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;

public class PowerAuthClientKeyFactory {
    private final KeyGenerator keyGenerator = new KeyGenerator();

    public List<SecretKey> keysForSignatureType(PowerAuthSignatureTypes signatureType, SecretKey possessionSignatureKey, SecretKey knowledgeSignatureKey, SecretKey biometrySignatureKey) {
        ArrayList<SecretKey> signatureKeys = new ArrayList<SecretKey>();
        if (signatureType.equals((Object)PowerAuthSignatureTypes.POSSESSION)) {
            signatureKeys.add(possessionSignatureKey);
        } else if (signatureType.equals((Object)PowerAuthSignatureTypes.KNOWLEDGE)) {
            signatureKeys.add(knowledgeSignatureKey);
        } else if (signatureType.equals((Object)PowerAuthSignatureTypes.BIOMETRY)) {
            signatureKeys.add(biometrySignatureKey);
        } else if (signatureType.equals((Object)PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE)) {
            signatureKeys.add(possessionSignatureKey);
            signatureKeys.add(knowledgeSignatureKey);
        } else if (signatureType.equals((Object)PowerAuthSignatureTypes.POSSESSION_BIOMETRY)) {
            signatureKeys.add(possessionSignatureKey);
            signatureKeys.add(biometrySignatureKey);
        } else if (signatureType.equals((Object)PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY)) {
            signatureKeys.add(possessionSignatureKey);
            signatureKeys.add(knowledgeSignatureKey);
            signatureKeys.add(biometrySignatureKey);
        }
        return signatureKeys;
    }

    public List<SecretKey> keysForSignatureType(PowerAuthSignatureTypes signatureType, SecretKey masterSecretKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        ArrayList<SecretKey> signatureKeys = new ArrayList<SecretKey>();
        if (signatureType.equals((Object)PowerAuthSignatureTypes.POSSESSION)) {
            SecretKey signatureKey = this.generateClientSignaturePossessionKey(masterSecretKey);
            signatureKeys.add(signatureKey);
        } else if (signatureType.equals((Object)PowerAuthSignatureTypes.KNOWLEDGE)) {
            SecretKey signatureKey = this.generateClientSignatureKnowledgeKey(masterSecretKey);
            signatureKeys.add(signatureKey);
        } else if (signatureType.equals((Object)PowerAuthSignatureTypes.BIOMETRY)) {
            SecretKey signatureKey = this.generateClientSignatureBiometryKey(masterSecretKey);
            signatureKeys.add(signatureKey);
        } else if (signatureType.equals((Object)PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE)) {
            SecretKey signatureKey = this.generateClientSignaturePossessionKey(masterSecretKey);
            signatureKeys.add(signatureKey);
            signatureKey = this.generateClientSignatureKnowledgeKey(masterSecretKey);
            signatureKeys.add(signatureKey);
        } else if (signatureType.equals((Object)PowerAuthSignatureTypes.POSSESSION_BIOMETRY)) {
            SecretKey signatureKey = this.generateClientSignaturePossessionKey(masterSecretKey);
            signatureKeys.add(signatureKey);
            signatureKey = this.generateClientSignatureBiometryKey(masterSecretKey);
            signatureKeys.add(signatureKey);
        } else if (signatureType.equals((Object)PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY)) {
            SecretKey signatureKey = this.generateClientSignaturePossessionKey(masterSecretKey);
            signatureKeys.add(signatureKey);
            signatureKey = this.generateClientSignatureKnowledgeKey(masterSecretKey);
            signatureKeys.add(signatureKey);
            signatureKey = this.generateClientSignatureBiometryKey(masterSecretKey);
            signatureKeys.add(signatureKey);
        }
        return signatureKeys;
    }

    public SecretKey generateClientMasterSecretKey(PrivateKey devicePrivateKey, PublicKey serverPublicKey) throws InvalidKeyException, CryptoProviderException {
        return this.keyGenerator.computeSharedKey(devicePrivateKey, serverPublicKey);
    }

    public SecretKey generateClientSignatureBiometryKey(SecretKey masterSecretKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        return this.keyGenerator.deriveSecretKey(masterSecretKey, PowerAuthDerivedKey.SIGNATURE_BIOMETRY.getIndex());
    }

    public SecretKey generateClientSignatureKnowledgeKey(SecretKey masterSecretKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        return this.keyGenerator.deriveSecretKey(masterSecretKey, PowerAuthDerivedKey.SIGNATURE_KNOWLEDGE.getIndex());
    }

    public SecretKey generateClientSignaturePossessionKey(SecretKey masterSecretKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        return this.keyGenerator.deriveSecretKey(masterSecretKey, PowerAuthDerivedKey.SIGNATURE_POSSESSION.getIndex());
    }

    public SecretKey generateServerEncryptedVaultKey(SecretKey masterSecretKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        return this.keyGenerator.deriveSecretKey(masterSecretKey, PowerAuthDerivedKey.ENCRYPTED_VAULT.getIndex());
    }

    public SecretKey generateServerTransportKey(SecretKey masterSecretKey) throws InvalidKeyException, GenericCryptoException, CryptoProviderException {
        return this.keyGenerator.deriveSecretKey(masterSecretKey, PowerAuthDerivedKey.TRANSPORT.getIndex());
    }
}

