/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.server.util;

import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.List;

public class DataDigest {
    private static final int AUTHORIZATION_CODE_LENGTH = 8;
    private HMACHashUtilities hmac = new HMACHashUtilities();

    public Result generateDigest(List<String> items) {
        try {
            if (items.size() == 0) {
                return null;
            }
            byte[] operationData = String.join((CharSequence)"&", items).getBytes("UTF-8");
            byte[] randomKey = new KeyGenerator().generateRandomBytes(16);
            byte[] otpHash = this.hmac.hash(randomKey, operationData);
            BigInteger otp = new BigInteger(otpHash).mod(BigInteger.TEN.pow(8));
            String digitFormat = "%" + String.format("%02d", 8) + "d";
            String digest = String.format(digitFormat, otp);
            return new Result(digest, randomKey);
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    public class Result {
        private String digest;
        private byte[] salt;

        Result(String digest, byte[] salt) {
            this.digest = digest;
            this.salt = salt;
        }

        public String getDigest() {
            return this.digest;
        }

        public byte[] getSalt() {
            return this.salt;
        }
    }
}

