/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.server.activation;

import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.client.activation.PowerAuthClientActivation;
import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.generator.IdentifierGenerator;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.AESEncryptionUtils;
import io.getlime.security.powerauth.crypto.lib.util.ECPublicKeyFingerprint;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import io.getlime.security.powerauth.crypto.lib.util.SignatureUtils;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;

public class PowerAuthServerActivation {
    private final IdentifierGenerator identifierGenerator = new IdentifierGenerator();
    private final SignatureUtils signatureUtils = new SignatureUtils();

    public String generateActivationId() {
        return this.identifierGenerator.generateActivationId();
    }

    public String generateActivationIdShort() {
        return this.identifierGenerator.generateActivationIdShort();
    }

    public String generateActivationOTP() {
        return this.identifierGenerator.generateActivationOTP();
    }

    public KeyPair generateServerKeyPair() {
        return new KeyGenerator().generateKeyPair();
    }

    public byte[] generateActivationSignature(String activationIdShort, String activationOTP, PrivateKey masterPrivateKey) throws InvalidKeyException {
        try {
            byte[] bytes = (activationIdShort + "-" + activationOTP).getBytes("UTF-8");
            byte[] signature = this.signatureUtils.computeECDSASignature(bytes, masterPrivateKey);
            return signature;
        }
        catch (UnsupportedEncodingException | SignatureException ex) {
            Logger.getLogger(PowerAuthServerActivation.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public byte[] generateActivationNonce() {
        return new KeyGenerator().generateRandomBytes(16);
    }

    public boolean validateApplicationSignature(String activationIdShort, byte[] activationNonce, byte[] encryptedDevicePublicKey, byte[] applicationKey, byte[] applicationSecret, byte[] signature) {
        try {
            String signatureBaseString = activationIdShort + "&" + BaseEncoding.base64().encode(activationNonce) + "&" + BaseEncoding.base64().encode(encryptedDevicePublicKey) + "&" + BaseEncoding.base64().encode(applicationKey);
            byte[] signatureExpected = new HMACHashUtilities().hash(applicationSecret, signatureBaseString.getBytes("UTF-8"));
            return Arrays.equals(signatureExpected, signature);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(PowerAuthClientActivation.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public PublicKey decryptDevicePublicKey(byte[] C_devicePublicKey, String activationIdShort, PrivateKey masterPrivateKey, PublicKey ephemeralPublicKey, String activationOTP, byte[] activationNonce) {
        try {
            byte[] activationIdShortBytes = activationIdShort.getBytes("UTF-8");
            SecretKey otpBasedSymmetricKey = new KeyGenerator().deriveSecretKeyFromPassword(activationOTP, activationIdShortBytes);
            if (ephemeralPublicKey != null) {
                KeyGenerator keyGenerator = new KeyGenerator();
                SecretKey ephemeralSymmetricKey = keyGenerator.computeSharedKey(masterPrivateKey, ephemeralPublicKey);
                AESEncryptionUtils aes = new AESEncryptionUtils();
                byte[] decryptedTMP = aes.decrypt(C_devicePublicKey, activationNonce, ephemeralSymmetricKey);
                byte[] decryptedPublicKeyBytes = aes.decrypt(decryptedTMP, activationNonce, otpBasedSymmetricKey);
                PublicKey devicePublicKey = PowerAuthConfiguration.INSTANCE.getKeyConvertor().convertBytesToPublicKey(decryptedPublicKeyBytes);
                return devicePublicKey;
            }
            AESEncryptionUtils aes = new AESEncryptionUtils();
            byte[] decryptedPublicKeyBytes = aes.decrypt(C_devicePublicKey, activationNonce, otpBasedSymmetricKey);
            PublicKey devicePublicKey = PowerAuthConfiguration.INSTANCE.getKeyConvertor().convertBytesToPublicKey(decryptedPublicKeyBytes);
            return devicePublicKey;
        }
        catch (UnsupportedEncodingException | InvalidKeyException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException ex) {
            Logger.getLogger(PowerAuthServerActivation.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public byte[] encryptServerPublicKey(PublicKey serverPublicKey, PublicKey devicePublicKey, PrivateKey ephemeralPrivateKey, String activationOTP, String activationIdShort, byte[] activationNonce) throws InvalidKeyException {
        try {
            byte[] serverPublicKeyBytes = PowerAuthConfiguration.INSTANCE.getKeyConvertor().convertPublicKeyToBytes(serverPublicKey);
            KeyGenerator keyGenerator = new KeyGenerator();
            SecretKey ephemeralSymmetricKey = keyGenerator.computeSharedKey(ephemeralPrivateKey, devicePublicKey);
            byte[] activationIdShortBytes = activationIdShort.getBytes("UTF-8");
            SecretKey otpBasedSymmetricKey = keyGenerator.deriveSecretKeyFromPassword(activationOTP, activationIdShortBytes);
            AESEncryptionUtils aes = new AESEncryptionUtils();
            byte[] encryptedTMP = aes.encrypt(serverPublicKeyBytes, activationNonce, otpBasedSymmetricKey);
            byte[] encryptServerPublicKey = aes.encrypt(encryptedTMP, activationNonce, ephemeralSymmetricKey);
            return encryptServerPublicKey;
        }
        catch (UnsupportedEncodingException | BadPaddingException | IllegalBlockSizeException ex) {
            Logger.getLogger(PowerAuthServerActivation.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public byte[] encryptedStatusBlob(byte statusByte, long counter, byte failedAttempts, byte maxFailedAttempts, SecretKey transportKey) throws InvalidKeyException {
        try {
            byte[] padding = new KeyGenerator().generateRandomBytes(17);
            byte[] zeroIv = new byte[16];
            byte[] statusBlob = ByteBuffer.allocate(32).putInt(-557785391).put(statusByte).putLong(counter).put(failedAttempts).put(maxFailedAttempts).put(padding).array();
            AESEncryptionUtils aes = new AESEncryptionUtils();
            byte[] C_statusBlob = aes.encrypt(statusBlob, zeroIv, transportKey, "AES/CBC/NoPadding");
            return C_statusBlob;
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            Logger.getLogger(PowerAuthServerActivation.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public byte[] computeServerDataSignature(String activationId, byte[] C_serverPublicKey, PrivateKey masterPrivateKey) throws InvalidKeyException, UnsupportedEncodingException {
        try {
            byte[] activationIdBytes = activationId.getBytes("UTF-8");
            String activationIdBytesBase64 = BaseEncoding.base64().encode(activationIdBytes);
            String C_serverPublicKeyBase64 = BaseEncoding.base64().encode(C_serverPublicKey);
            byte[] result = (activationIdBytesBase64 + "&" + C_serverPublicKeyBase64).getBytes("UTF-8");
            return this.signatureUtils.computeECDSASignature(result, masterPrivateKey);
        }
        catch (SignatureException ex) {
            Logger.getLogger(PowerAuthServerActivation.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String computeDevicePublicKeyFingerprint(PublicKey devicePublicKey) {
        try {
            return ECPublicKeyFingerprint.compute((ECPublicKey)devicePublicKey);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(PowerAuthServerActivation.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

