/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.util;

import com.google.common.primitives.Bytes;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.UUID;

public class TokenUtils {
    private KeyGenerator keyGenerator = new KeyGenerator();
    private HMACHashUtilities hmac = new HMACHashUtilities();

    public String generateTokenId() {
        return UUID.randomUUID().toString();
    }

    public byte[] generateTokenSecret() {
        return this.keyGenerator.generateRandomBytes(16);
    }

    public byte[] generateTokenNonce() {
        return this.keyGenerator.generateRandomBytes(16);
    }

    public byte[] generateTokenTimestamp() {
        try {
            return String.valueOf(System.currentTimeMillis()).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public byte[] convertTokenTimestamp(long timestamp) {
        try {
            return String.valueOf(timestamp).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public byte[] computeTokenDigest(byte[] nonce, byte[] timestamp, byte[] tokenSecret) {
        try {
            byte[] amp = "&".getBytes("UTF-8");
            byte[] data = Bytes.concat((byte[][])new byte[][]{nonce, amp, timestamp});
            return this.hmac.hash(tokenSecret, data);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public boolean validateTokenDigest(byte[] nonce, byte[] timestamp, byte[] tokenSecret, byte[] tokenDigest) {
        return Arrays.equals(this.computeTokenDigest(nonce, timestamp, tokenSecret), tokenDigest);
    }
}

