/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Hash {
    private static byte[] hash(byte[] originalBytes, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        return md.digest(originalBytes);
    }

    public static byte[] sha256(byte[] originalBytes) {
        try {
            return Hash.hash(originalBytes, "SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static byte[] sha256(String string) {
        try {
            return Hash.sha256(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte[] sha256(String string, String charset) throws UnsupportedEncodingException {
        byte[] originalBytes = string.getBytes(charset);
        return Hash.sha256(originalBytes);
    }
}

